"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobsListPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _space_management_context_wrapper = require("../../../../components/space_management_context_wrapper");
var _upgrade_warning = require("../../../../components/upgrade/upgrade_warning");
var _get_services = require("../../../../util/get_services");
var _ml = require("../../../../contexts/ml");
var _app = require("../../../../../../common/constants/app");
var _check_capabilities = require("../../../../capabilities/check_capabilities");
var _access_denied_page = require("../access_denied_page");
var _insufficient_license_page = require("../insufficient_license_page");
var _job_spaces_sync = require("../../../../components/job_spaces_sync");
var _import_export_jobs = require("../../../../components/import_export_jobs");
var _space_management = require("./space_management");
var _docs_link = require("./docs_link");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JobsListPage = ({
  coreStart,
  share,
  history,
  spaces,
  data,
  usageCollection,
  fieldFormats,
  isServerless,
  mlFeatures
}) => {
  const [initialized, setInitialized] = (0, _react.useState)(false);
  const [accessDenied, setAccessDenied] = (0, _react.useState)(false);
  const [isUpgradeInProgress, setIsUpgradeInProgress] = (0, _react.useState)(false);
  const [isPlatinumOrTrialLicense, setIsPlatinumOrTrialLicense] = (0, _react.useState)(true);
  const [showSyncFlyout, setShowSyncFlyout] = (0, _react.useState)(false);
  const [currentTabId, setCurrentTabId] = (0, _react.useState)('anomaly-detector');
  // callback to allow import flyout to refresh jobs list
  const [refreshJobs, setRefreshJobs] = (0, _react.useState)(null);
  const mlServices = (0, _react.useMemo)(() => (0, _get_services.getMlGlobalServices)(coreStart, data.dataViews, usageCollection), [coreStart, data.dataViews, usageCollection]);
  const check = async () => {
    try {
      await (0, _check_capabilities.checkGetManagementMlJobsResolver)(mlServices);
    } catch (e) {
      if (e.mlFeatureEnabledInSpace && e.isPlatinumOrTrialLicense === false) {
        setIsPlatinumOrTrialLicense(false);
      } else if (e.isUpgradeInProgress) {
        setIsUpgradeInProgress(true);
      } else {
        setAccessDenied(true);
      }
    }
    setInitialized(true);
  };
  const [canCreateJob] = (0, _check_capabilities.usePermissionCheck)(['canCreateJob']);
  (0, _react.useEffect)(() => {
    check();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  if (initialized === false) {
    return null;
  }
  function onCloseSyncFlyout() {
    if (typeof refreshJobs === 'function') {
      refreshJobs();
    }
    setShowSyncFlyout(false);
  }
  if (isUpgradeInProgress) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, coreStart, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        ...coreStart,
        share,
        data,
        usageCollection,
        fieldFormats,
        spaces,
        mlServices
      }
    }, /*#__PURE__*/_react.default.createElement(_upgrade_warning.UpgradeWarning, null))));
  }
  if (accessDenied) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, coreStart, /*#__PURE__*/_react.default.createElement(_access_denied_page.AccessDeniedPage, null)));
  }
  if (isPlatinumOrTrialLicense === false) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, coreStart, /*#__PURE__*/_react.default.createElement(_insufficient_license_page.InsufficientLicensePage, {
      basePath: coreStart.http.basePath
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, coreStart, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application: coreStart.application
    }
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...coreStart,
      share,
      data,
      usageCollection,
      fieldFormats,
      spaces,
      mlServices
    }
  }, /*#__PURE__*/_react.default.createElement(_space_management_context_wrapper.SpaceManagementContextWrapper, {
    feature: _app.PLUGIN_ID
  }, /*#__PURE__*/_react.default.createElement(_ml.EnabledFeaturesContextProvider, {
    isServerless: isServerless,
    mlFeatures: mlFeatures
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
    pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.management.jobsList.jobsListTitle",
      defaultMessage: "Machine Learning"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.management.jobsList.jobsListTagline",
      defaultMessage: "Identify, analyze, and process your data using advanced analysis techniques."
    }),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_docs_link.DocsLink, {
      currentTabId: currentTabId
    })],
    bottomBorder: true,
    paddingSize: 'none'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    paddingSize: 'none',
    id: "kibanaManagementMLSection",
    "data-test-subj": "mlPageStackManagementJobsList"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    disabled: !canCreateJob,
    onClick: () => setShowSyncFlyout(true),
    "data-test-subj": "mlStackMgmtSyncButton"
  }, _i18n.i18n.translate('xpack.ml.management.jobsList.syncFlyoutButton', {
    defaultMessage: 'Synchronize saved objects'
  })), showSyncFlyout && /*#__PURE__*/_react.default.createElement(_job_spaces_sync.JobSpacesSyncFlyout, {
    onClose: onCloseSyncFlyout
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_import_export_jobs.ExportJobsFlyout, {
    isDisabled: !canCreateJob,
    currentTab: currentTabId === 'trained-model' ? 'anomaly-detector' : currentTabId
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_import_export_jobs.ImportJobsFlyout, {
    isDisabled: !canCreateJob,
    onImportComplete: refreshJobs
  }))), /*#__PURE__*/_react.default.createElement(_space_management.SpaceManagement, {
    spacesApi: spaces,
    onTabChange: setCurrentTabId,
    onReload: setRefreshJobs
  })))))))));
};
exports.JobsListPage = JobsListPage;