"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Description = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../../../../contexts/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Description = exports.Description = /*#__PURE__*/(0, _react.memo)(({
  children,
  validation,
  titleId
}) => {
  const title = _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.summaryCountField.title', {
    defaultMessage: 'Summary count field'
  });
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const docsUrl = docLinks.links.ml.aggregations;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", {
      id: titleId
    }, title),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.pickFieldsStep.summaryCountField.description",
      defaultMessage: "If the input data is {aggregated}, specify the field that contains the document count.",
      values: {
        aggregated: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docsUrl,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.newJob.wizard.pickFieldsStep.summaryCountField.aggregatedText",
          defaultMessage: "aggregated"
        }))
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: validation.message,
    isInvalid: validation.valid === false
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)));
});