"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityLegendControl = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _select_severity = require("../../../components/controls/select_severity");
var _severity_legend_control_styles = require("./severity_legend_control_styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SeverityLegendControl = ({
  allSeverityOptions,
  selectedSeverities,
  onChange,
  dataTestSubj = 'severity-legend-control'
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = (0, _severity_legend_control_styles.useSeverityLegendControlStyles)();
  const handleSeverityClick = (0, _react.useCallback)(clickedSeverity => {
    const isCurrentlySelected = selectedSeverities.some(severity => severity.val === clickedSeverity.val);
    const allSelected = selectedSeverities.length === allSeverityOptions.length;
    let newSelectedSeverities;

    // If all are selected, select only the clicked one
    if (allSelected) {
      newSelectedSeverities = [clickedSeverity];
    }
    // If trying to deselect the last selected option, select all instead
    else if (isCurrentlySelected && selectedSeverities.length === 1) {
      newSelectedSeverities = [...allSeverityOptions];
    }
    // If deselecting one of multiple selected options
    else if (isCurrentlySelected) {
      newSelectedSeverities = selectedSeverities.filter(severity => severity.val !== clickedSeverity.val);
    }
    // If selecting an additional option
    else {
      newSelectedSeverities = [...selectedSeverities, clickedSeverity];
    }
    onChange(newSelectedSeverities);
  }, [selectedSeverities, allSeverityOptions, onChange]);
  const severityControl = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false
  }, allSeverityOptions.map(severity => {
    const isSelected = selectedSeverities.some(s => s.val === severity.val);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: severity.val,
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      onClick: () => handleSeverityClick(severity),
      css: styles.severityButton,
      "data-test-subj": `${dataTestSubj}-item-${severity.val}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: isSelected ? 'dot' : 'eyeClosed',
      color: isSelected ? severity.color : euiTheme.colors.textDisabled,
      size: isSelected ? 'm' : 's'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      css: styles.severityText(isSelected)
    }, (0, _select_severity.getSeverityRangeDisplay)(severity.val))))));
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayout, {
    compressed: true,
    prepend: _i18n.i18n.translate('xpack.ml.explorer.severityLegendControl.anomalyScoreLabel', {
      defaultMessage: 'Anomaly score'
    }),
    fullWidth: true,
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.severityControl
  }, severityControl));
};
exports.SeverityLegendControl = SeverityLegendControl;