"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isUrlDrilldown = isUrlDrilldown;
exports.toValueClickDataFormat = toValueClickDataFormat;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isUrlDrilldown(action) {
  return action.type === 'URL_DRILLDOWN';
}

// VALUE_CLICK_TRIGGER is coupled with expressions and Datatable type
// URL drilldown parses event scope from Datatable
// https://github.com/elastic/kibana/blob/7.10/x-pack/plugins/drilldowns/url_drilldown/public/lib/url_drilldown_scope.ts#L140
// In order to use URL drilldown, maps has to package its data in Datatable compatiable format.
function toValueClickDataFormat(key, value) {
  return [{
    table: {
      columns: [{
        id: key,
        meta: {
          type: 'unknown',
          // type is not used by URL drilldown to parse event but is required by DatatableColumnMeta
          field: key
        },
        name: key
      }],
      rows: [{
        [key]: value
      }]
    },
    column: 0,
    row: 0,
    value
  }];
}