"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapMarker = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _right_aligned_text = require("../right_aligned_text");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FONT_SIZE = 10;
const MapMarker = ({
  circleCenterX,
  circleCenterY,
  circleTopY,
  formattedValue,
  radius,
  textOffset,
  textY,
  onWidthChange
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const circleStyle = {
    fillOpacity: 0,
    stroke: euiTheme.colors.textParagraph,
    strokeWidth: 1
  };
  return /*#__PURE__*/_react.default.createElement("g", {
    key: radius
  }, /*#__PURE__*/_react.default.createElement("line", {
    style: {
      stroke: euiTheme.border.color
    },
    x1: circleCenterX,
    y1: circleTopY,
    x2: circleCenterX * 2.25,
    y2: circleTopY
  }), /*#__PURE__*/_react.default.createElement(_right_aligned_text.RightAlignedText, {
    setWidth: onWidthChange,
    style: {
      fontSize: FONT_SIZE,
      fill: euiTheme.colors.textParagraph
    },
    x: circleCenterX * 2.25 + textOffset,
    y: textY,
    value: formattedValue
  }), /*#__PURE__*/_react.default.createElement("circle", {
    style: {
      ...circleStyle,
      stroke: euiTheme.colors.textParagraph
    },
    cx: circleCenterX,
    cy: circleCenterY,
    r: radius
  }));
};
exports.MapMarker = MapMarker;