"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerServices = registerServices;
var _get_logs_rate_timeseries = require("./get_logs_rate_timeseries/get_logs_rate_timeseries");
var _get_logs_error_rate_timeseries = require("./get_logs_error_rate_timeseries/get_logs_error_rate_timeseries");
var _get_logs_rates_service = require("./get_logs_rates_service");
var _log_sources_service = require("./log_sources_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerServices(params) {
  return {
    getLogsRatesService: (0, _get_logs_rates_service.createGetLogsRatesService)(),
    getLogsRateTimeseries: (0, _get_logs_rate_timeseries.createGetLogsRateTimeseries)(),
    getLogsErrorRateTimeseries: (0, _get_logs_error_rate_timeseries.createGetLogErrorRateTimeseries)(),
    logSourcesServiceFactory: (0, _log_sources_service.createLogSourcesServiceFactory)(params)
  };
}