"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinksContext = void 0;
exports.deserializeState = deserializeState;
exports.getLinksEmbeddableFactory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _react2 = require("@emotion/react");
var _presentationContainers = require("@kbn/presentation-containers");
var _content_management = require("../../common/content_management");
var _dashboard_link_component = require("../components/dashboard_link/dashboard_link_component");
var _external_link_component = require("../components/external_link/external_link_component");
var _common = require("../../common");
var _persistable_state = require("../../common/persistable_state");
var _content_management2 = require("../content_management");
var _resolve_links = require("../lib/resolve_links");
var _deserialize_from_library = require("../lib/deserialize_from_library");
var _serialize_attributes = require("../lib/serialize_attributes");
var _add_links_panel_action = require("../actions/add_links_panel_action");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const LinksContext = exports.LinksContext = /*#__PURE__*/(0, _react.createContext)(null);
async function deserializeState(serializedState) {
  var _serializedState$refe, _attributesWithInject;
  // Clone the state to avoid an object not extensible error when injecting references
  const state = (0, _lodash.cloneDeep)(serializedState.rawState);
  const {
    title,
    description,
    hidePanelTitles
  } = serializedState.rawState;
  if ((0, _deserialize_from_library.linksSerializeStateIsByReference)(state)) {
    const linksSavedObject = await _content_management2.linksClient.get(state.savedObjectId);
    const runtimeState = await (0, _deserialize_from_library.deserializeLinksSavedObject)(linksSavedObject.item);
    return {
      ...runtimeState,
      title,
      description,
      hidePanelTitles
    };
  }
  const {
    attributes: attributesWithInjectedIds
  } = (0, _persistable_state.injectReferences)({
    attributes: state.attributes,
    references: (_serializedState$refe = serializedState.references) !== null && _serializedState$refe !== void 0 ? _serializedState$refe : []
  });
  const resolvedLinks = await (0, _resolve_links.resolveLinks)((_attributesWithInject = attributesWithInjectedIds.links) !== null && _attributesWithInject !== void 0 ? _attributesWithInject : []);
  return {
    title,
    description,
    hidePanelTitles,
    links: resolvedLinks,
    layout: attributesWithInjectedIds.layout,
    defaultTitle: attributesWithInjectedIds.title,
    defaultDescription: attributesWithInjectedIds.description
  };
}
const getLinksEmbeddableFactory = () => {
  const linksEmbeddableFactory = {
    type: _content_management.CONTENT_ID,
    buildEmbeddable: async ({
      initialState,
      finalizeApi,
      uuid,
      parentApi
    }) => {
      const titleManager = (0, _presentationPublishing.initializeTitleManager)(initialState.rawState);
      const savedObjectId = (0, _deserialize_from_library.linksSerializeStateIsByReference)(initialState.rawState) ? initialState.rawState.savedObjectId : undefined;
      const isByReference = savedObjectId !== undefined;
      const initialRuntimeState = await deserializeState(initialState);
      const blockingError$ = new _rxjs.BehaviorSubject(undefined);
      if (!(0, _add_links_panel_action.isParentApiCompatible)(parentApi)) blockingError$.next(new _public.PanelIncompatibleError());
      const stateManager = (0, _presentationPublishing.initializeStateManager)(initialRuntimeState, {
        defaultDescription: undefined,
        defaultTitle: undefined,
        layout: undefined,
        links: undefined
      });
      function serializeByReference(id) {
        return {
          rawState: {
            ...titleManager.getLatestState(),
            savedObjectId: id
          },
          references: []
        };
      }
      function serializeByValue() {
        const {
          attributes,
          references
        } = (0, _serialize_attributes.serializeLinksAttributes)(stateManager.getLatestState());
        return {
          rawState: {
            ...titleManager.getLatestState(),
            attributes
          },
          references
        };
      }
      const serializeState = () => isByReference ? serializeByReference(savedObjectId) : serializeByValue();
      const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
        uuid,
        parentApi,
        serializeState,
        anyStateChange$: (0, _rxjs.merge)(titleManager.anyStateChange$, stateManager.anyStateChange$),
        getComparators: () => {
          return {
            ..._presentationPublishing.titleComparators,
            attributes: isByReference ? 'skip' : (a, b) => {
              var _a$links, _b$links, _a$links2;
              if ((a === null || a === void 0 ? void 0 : a.title) !== (b === null || b === void 0 ? void 0 : b.title) || (a === null || a === void 0 ? void 0 : a.description) !== (b === null || b === void 0 ? void 0 : b.description) || (a === null || a === void 0 ? void 0 : a.layout) !== (b === null || b === void 0 ? void 0 : b.layout) || (a === null || a === void 0 ? void 0 : (_a$links = a.links) === null || _a$links === void 0 ? void 0 : _a$links.length) !== (b === null || b === void 0 ? void 0 : (_b$links = b.links) === null || _b$links === void 0 ? void 0 : _b$links.length)) {
                return false;
              }
              const hasLinkDifference = ((_a$links2 = a === null || a === void 0 ? void 0 : a.links) !== null && _a$links2 !== void 0 ? _a$links2 : []).some((linkFromA, index) => {
                var _b$links2;
                const linkFromB = b === null || b === void 0 ? void 0 : (_b$links2 = b.links) === null || _b$links2 === void 0 ? void 0 : _b$links2[index];
                return !(0, _fastDeepEqual.default)((0, _lodash.omitBy)(linkFromA, _lodash.isUndefined), (0, _lodash.omitBy)(linkFromB, _lodash.isUndefined));
              });
              return !hasLinkDifference;
            },
            savedObjectId: 'skip'
          };
        },
        onReset: async lastSaved => {
          titleManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          if (lastSaved && !isByReference) {
            const lastSavedRuntimeState = await deserializeState(lastSaved);
            stateManager.reinitializeState(lastSavedRuntimeState);
          }
        }
      });
      const api = finalizeApi({
        ...titleManager.api,
        ...unsavedChangesApi,
        blockingError$,
        defaultTitle$: stateManager.api.defaultTitle$,
        defaultDescription$: stateManager.api.defaultDescription$,
        isEditingEnabled: () => Boolean(blockingError$.value === undefined),
        getTypeDisplayName: () => _common.DISPLAY_NAME,
        serializeState,
        saveToLibrary: async newTitle => {
          stateManager.api.setDefaultTitle(newTitle);
          const {
            attributes,
            references
          } = (0, _serialize_attributes.serializeLinksAttributes)(stateManager.getLatestState());
          const {
            item: {
              id
            }
          } = await _content_management2.linksClient.create({
            data: {
              ...attributes,
              title: newTitle
            },
            options: {
              references
            }
          });
          return id;
        },
        getSerializedStateByValue: serializeByValue,
        getSerializedStateByReference: serializeByReference,
        canLinkToLibrary: async () => !isByReference,
        canUnlinkFromLibrary: async () => isByReference,
        checkForDuplicateTitle: async (newTitle, isTitleDuplicateConfirmed, onTitleDuplicate) => {
          await (0, _content_management2.checkForDuplicateTitle)({
            title: newTitle,
            copyOnSave: false,
            lastSavedTitle: '',
            isTitleDuplicateConfirmed,
            onTitleDuplicate
          });
        },
        onEdit: async () => {
          const {
            openEditorFlyout
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('../editor/open_editor_flyout')));
          const newState = await openEditorFlyout({
            initialState: {
              ...stateManager.getLatestState(),
              savedObjectId
            },
            parentDashboard: parentApi
          });
          if (!newState) return;

          // if the by reference state has changed during this edit, reinitialize the panel.
          const nextSavedObjectId = newState === null || newState === void 0 ? void 0 : newState.savedObjectId;
          const nextIsByReference = nextSavedObjectId !== undefined;
          if (nextIsByReference !== isByReference && (0, _presentationContainers.apiIsPresentationContainer)(api.parentApi)) {
            const serializedState = nextIsByReference ? serializeByReference(nextSavedObjectId) : serializeByValue();
            serializedState.rawState.title = newState.title;
            api.parentApi.replacePanel(api.uuid, {
              serializedState,
              panelType: api.type
            });
            return;
          }
          stateManager.reinitializeState(newState);
        }
      });
      const Component = () => {
        const [links, layout] = (0, _presentationPublishing.useBatchedPublishingSubjects)(stateManager.api.links$, stateManager.api.layout$);
        const linkItems = (0, _react.useMemo)(() => {
          if (!links) return {};
          return links.reduce((prev, currentLink) => {
            return {
              ...prev,
              [currentLink.id]: {
                id: currentLink.id,
                content: currentLink.type === _content_management.DASHBOARD_LINK_TYPE ? /*#__PURE__*/_react.default.createElement(_dashboard_link_component.DashboardLinkComponent, {
                  key: currentLink.id,
                  link: currentLink,
                  layout: layout !== null && layout !== void 0 ? layout : _content_management.LINKS_VERTICAL_LAYOUT,
                  parentApi: parentApi
                }) : /*#__PURE__*/_react.default.createElement(_external_link_component.ExternalLinkComponent, {
                  key: currentLink.id,
                  link: currentLink,
                  layout: layout !== null && layout !== void 0 ? layout : _content_management.LINKS_VERTICAL_LAYOUT
                })
              }
            };
          }, {});
        }, [links, layout]);
        return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
          className: layout === _content_management.LINKS_HORIZONTAL_LAYOUT ? 'eui-xScroll' : 'eui-yScroll',
          paddingSize: "xs",
          "data-shared-item": true,
          "data-rendering-count": 1,
          "data-test-subj": "links--component",
          borderRadius: "none"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
          maxWidth: false,
          css: styles,
          className: `${layout !== null && layout !== void 0 ? layout : _content_management.LINKS_VERTICAL_LAYOUT}LayoutWrapper`,
          "data-test-subj": "links--component--listGroup"
        }, links === null || links === void 0 ? void 0 : links.map(link => linkItems[link.id].content)));
      };
      return {
        api,
        Component
      };
    }
  };
  return linksEmbeddableFactory;
};
exports.getLinksEmbeddableFactory = getLinksEmbeddableFactory;
const styles = ({
  euiTheme
}) => (0, _react2.css)({
  '.linksPanelLink': {
    maxWidth: 'fit-content' // ensures that the error tooltip shows up **right beside** the link label
  },
  '&.verticalLayoutWrapper': {
    gap: euiTheme.size.xs
  },
  '&.horizontalLayoutWrapper': {
    height: '100%',
    display: 'flex',
    flexWrap: 'nowrap',
    alignItems: 'center',
    flexDirection: 'row'
  }
});