"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfoBadge = InfoBadge;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InfoBadge({
  title,
  dataView,
  index,
  palette,
  children,
  'data-test-subj-prefix': dataTestSubjPrefix
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const hasColor = Boolean(palette);
  const hasSingleColor = palette && palette.length === 1;
  const hasMultipleColors = palette && palette.length > 1;
  const iconType = hasSingleColor ? 'stopFilled' : 'color';
  return /*#__PURE__*/_react2.default.createElement("li", {
    key: `${title}-${dataView}-${index}`,
    "data-test-subj": `${dataTestSubjPrefix}-${index}`,
    css: (0, _react.css)`
        margin: ${euiTheme.size.base} 0 0;
      `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, hasColor ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    color: hasSingleColor ? palette[0] : undefined,
    type: iconType,
    "data-test-subj": `${dataTestSubjPrefix}-${index}-icon`
  })) : null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": `${dataTestSubjPrefix}-${index}-title`
  }, title)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, children)), hasMultipleColors ? /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
            margin-top: ${euiTheme.size.xs};
            overflow-y: hidden;
            height: ${euiTheme.size.xs};
            margin-left: ${euiTheme.size.l};
          `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiColorPaletteDisplay, {
    size: "xs",
    palette: palette,
    "data-test-subj": `${dataTestSubjPrefix}-${index}-palette`
  })) : null);
}