"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.displayDuplicateTitleConfirmModal = displayDuplicateTitleConfirmModal;
var _i18n = require("@kbn/i18n");
var _constants = require("./constants");
var _confirm_modal_promise = require("./confirm_modal_promise");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function displayDuplicateTitleConfirmModal({
  title,
  displayName
}, startServices) {
  const confirmMessage = _i18n.i18n.translate('xpack.lens.confirmModal.saveDuplicateConfirmationMessage', {
    defaultMessage: `A {name} with the title ''{title}'' already exists. Would you like to save anyway?`,
    values: {
      title,
      name: displayName
    }
  });
  const confirmButtonText = _i18n.i18n.translate('xpack.lens.confirmModal.saveDuplicateButtonLabel', {
    defaultMessage: 'Save {name}',
    values: {
      name: displayName
    }
  });
  try {
    return (0, _confirm_modal_promise.confirmModalPromise)(confirmMessage, '', confirmButtonText, startServices);
  } catch {
    return Promise.reject(new Error(_constants.SAVE_DUPLICATE_REJECTED));
  }
}