"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryTracer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _base = require("@langchain/core/tracers/base");
var _tools = require("../../utils/tools");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * TelemetryTracer is a tracer that uses event based telemetry to track LangChain events.
 */
class TelemetryTracer extends _base.BaseTracer {
  constructor(fields, logger) {
    super(fields);
    (0, _defineProperty2.default)(this, "name", 'telemetry_tracer');
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "elasticTools", void 0);
    (0, _defineProperty2.default)(this, "telemetry", void 0);
    (0, _defineProperty2.default)(this, "telemetryParams", void 0);
    this.logger = logger.get('telemetryTracer');
    this.elasticTools = fields.elasticTools;
    this.telemetry = fields.telemetry;
    this.telemetryParams = fields.telemetryParams;
  }
  async onToolError(run) {
    const eventType = 'invoke_assistant_error';
    const telemetryValue = {
      actionTypeId: this.telemetryParams.actionTypeId,
      model: this.telemetryParams.model,
      errorMessage: run.error,
      assistantStreamingEnabled: this.telemetryParams.assistantStreamingEnabled,
      isEnabledKnowledgeBase: this.telemetryParams.isEnabledKnowledgeBase,
      errorLocation: `executeTools-${run.name}`
    };
    this.logger.debug(() => `Invoke ${eventType} telemetry:\n${JSON.stringify(telemetryValue, null, 2)}`);
    this.telemetry.reportEvent(eventType, telemetryValue);
  }
  async onChainEnd(run) {
    if (!run.parent_run_id) {
      var _run$end_time, _run$start_time;
      const {
        eventType,
        ...telemetryParams
      } = this.telemetryParams;
      const toolsInvoked = run !== null && run !== void 0 && run.outputs && run !== null && run !== void 0 && run.outputs.messages.length ? run.outputs.messages.reduce((acc, message) => {
        if ((0, _tools.containsToolCalls)(message)) {
          // Calculate counts for each tool call for the message
          const toolCountForMessage = message.tool_calls.reduce((messageToolUseCount, toolCall) => {
            const toolName = this.elasticTools.includes(toolCall.name) ? toolCall.name : 'CustomTool';
            if (!(toolName in messageToolUseCount)) {
              messageToolUseCount[toolName] = 0;
            }
            messageToolUseCount[toolName] += 1;
            return messageToolUseCount;
          }, {});

          // Merge the counts into the accumulator
          Object.entries(toolCountForMessage).forEach(([toolName, count]) => {
            if (!(toolName in acc)) {
              acc[toolName] = 0;
            }
            acc[toolName] += count;
          });
        }
        return acc;
      }, {}) : {};
      const telemetryValue = {
        ...telemetryParams,
        durationMs: ((_run$end_time = run.end_time) !== null && _run$end_time !== void 0 ? _run$end_time : 0) - ((_run$start_time = run.start_time) !== null && _run$start_time !== void 0 ? _run$start_time : 0),
        toolsInvoked,
        ...(telemetryParams.actionTypeId === '.gen-ai' ? {
          isOssModel: run.inputs.isOssModel
        } : {})
      };
      this.logger.debug(() => `Invoke ${eventType} telemetry:\n${JSON.stringify(telemetryValue, null, 2)}`);
      this.telemetry.reportEvent(eventType, telemetryValue);
    }
  }

  // everything below is required for type only
  async persistRun(_run) {}
}
exports.TelemetryTracer = TelemetryTracer;