"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobSetupScreen = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _react2 = require("@emotion/react");
var _metrics_source = require("../../../containers/metrics_source");
var _module = require("../../../containers/ml/modules/metrics_hosts/module");
var _module2 = require("../../../containers/ml/modules/metrics_k8s/module");
var _fixed_datepicker = require("../../fixed_datepicker");
var _module_descriptor = require("../../../containers/ml/modules/metrics_k8s/module_descriptor");
var _kuery = require("../../../utils/kuery");
var _flyout_home = require("./flyout_home");
var _use_kibana = require("../../../hooks/use_kibana");
var _kuery_bar = require("../../../pages/metrics/metrics_explorer/components/kuery_bar");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JobSetupScreen = props => {
  var _metricsView$fields;
  const [now] = (0, _react.useState)(() => (0, _moment.default)());
  const {
    goHome
  } = props;
  const [startDate, setStartDate] = (0, _react.useState)(now.clone().subtract(4, 'weeks'));
  const [partitionField, setPartitionField] = (0, _react.useState)(null);
  const host = (0, _module.useMetricHostsModuleContext)();
  const kubernetes = (0, _module2.useMetricK8sModuleContext)();
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const [filter, setFilter] = (0, _react.useState)('');
  const [filterQuery, setFilterQuery] = (0, _react.useState)('');
  const trackMetric = (0, _public.useUiTracker)({
    app: 'infra_metrics'
  });
  const {
    kibanaVersion,
    isCloudEnv,
    isServerlessEnv
  } = (0, _react.useContext)(_use_kibana.KibanaEnvironmentContext);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    telemetry
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  const indices = host.sourceConfiguration.indices;
  const setupStatus = (0, _react.useMemo)(() => {
    if (props.jobType === 'kubernetes') {
      return kubernetes.setupStatus;
    } else {
      return host.setupStatus;
    }
  }, [props.jobType, kubernetes.setupStatus, host.setupStatus]);
  const cleanUpAndSetUpModule = (0, _react.useMemo)(() => {
    if (props.jobType === 'kubernetes') {
      return kubernetes.cleanUpAndSetUpModule;
    } else {
      return host.cleanUpAndSetUpModule;
    }
  }, [props.jobType, kubernetes.cleanUpAndSetUpModule, host.cleanUpAndSetUpModule]);
  const setUpModule = (0, _react.useMemo)(() => {
    if (props.jobType === 'kubernetes') {
      return kubernetes.setUpModule;
    } else {
      return host.setUpModule;
    }
  }, [props.jobType, kubernetes.setUpModule, host.setUpModule]);
  const hasSummaries = (0, _react.useMemo)(() => {
    if (props.jobType === 'kubernetes') {
      return kubernetes.jobSummaries.length > 0;
    } else {
      return host.jobSummaries.length > 0;
    }
  }, [props.jobType, kubernetes.jobSummaries, host.jobSummaries]);
  const updateStart = (0, _react.useCallback)(date => {
    setStartDate(date);
    telemetry.reportAnomalyDetectionDateFieldChange({
      job_type: props.jobType,
      start_date: date.toISOString()
    });
  }, [telemetry, props.jobType]);
  const createJobs = (0, _react.useCallback)(() => {
    const date = (0, _moment.default)(startDate).toDate();
    if (hasSummaries) {
      telemetry.reportAnomalyDetectionSetup({
        job_type: props.jobType,
        configured_fields: {
          start_date: date.toISOString(),
          partition_field: partitionField ? partitionField[0] : undefined,
          filter_field: filter ? filter : undefined
        }
      });
      cleanUpAndSetUpModule(indices, date.getTime(), undefined, filterQuery, partitionField ? partitionField[0] : undefined);
    } else {
      telemetry.reportAnomalyDetectionSetup({
        job_type: props.jobType,
        configured_fields: {
          start_date: date.toISOString(),
          partition_field: partitionField ? partitionField[0] : undefined,
          filter_field: filter
        }
      });
      setUpModule(indices, date.getTime(), undefined, filterQuery, partitionField ? partitionField[0] : undefined);
    }
  }, [cleanUpAndSetUpModule, filterQuery, setUpModule, hasSummaries, indices, partitionField, startDate, telemetry, filter, props.jobType]);
  const onFilterChange = (0, _react.useCallback)(f => {
    setFilter(f || '');
    setFilterQuery((0, _kuery.convertKueryToElasticSearchQuery)(f, metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference) || '');
    telemetry.reportAnomalyDetectionFilterFieldChange({
      job_type: props.jobType,
      filter_field: f ? f : undefined
    });
  }, [metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference, telemetry, props.jobType]);

  /* eslint-disable-next-line react-hooks/exhaustive-deps */
  const debouncedOnFilterChange = (0, _react.useCallback)((0, _lodash.debounce)(onFilterChange, 500), [onFilterChange]);
  const onPartitionFieldChange = (0, _react.useCallback)(value => {
    setPartitionField(value.map(v => v.label));
    telemetry.reportAnomalyDetectionPartitionFieldChange({
      job_type: props.jobType,
      partition_field: value.length > 0 ? value[0].label : undefined
    });
  }, [telemetry, props.jobType]);
  (0, _react.useEffect)(() => {
    if (props.jobType === 'kubernetes') {
      setPartitionField([_module_descriptor.DEFAULT_K8S_PARTITION_FIELD]);
    }
  }, [props.jobType]);
  (0, _react.useEffect)(() => {
    if (setupStatus.type === 'succeeded') {
      if (props.jobType === 'kubernetes') {
        trackMetric({
          metric: 'metrics_ml_anomaly_detection_k8s_enabled'
        });
        if (partitionField && (partitionField.length !== 1 || partitionField[0] !== _module_descriptor.DEFAULT_K8S_PARTITION_FIELD)) {
          trackMetric({
            metric: 'metrics_ml_anomaly_detection_k8s_partition_changed'
          });
        }
      } else {
        trackMetric({
          metric: 'metrics_ml_anomaly_detection_hosts_enabled'
        });
        if (partitionField) {
          trackMetric({
            metric: 'metrics_ml_anomaly_detection_hosts_partition_changed'
          });
        }
        trackMetric({
          metric: 'metrics_ml_anomaly_detection_hosts_enabled'
        });
      }
      goHome();
    }
  }, [setupStatus, props.jobType, partitionField, trackMetric, goHome]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Enable machine learning for {nodeType}",
    id: "xpack.infra.ml.aomalyFlyout.jobSetup.flyoutHeader",
    values: {
      nodeType: props.jobType
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
              margin-right: ${euiTheme.size.l};
            `
  }, /*#__PURE__*/_react.default.createElement(_public.FeatureFeedbackButton, {
    "data-test-subj": `infraML${props.jobType}FlyoutFeedbackLink`,
    formUrl: _flyout_home.INFRA_ML_FLYOUT_FEEDBACK_LINK,
    sanitizedPath: document.location.pathname,
    kibanaVersion: kibanaVersion,
    isCloudEnv: isCloudEnv,
    isServerlessEnv: isServerlessEnv,
    nodeType: props.jobType === 'kubernetes' ? 'pod' : 'host'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, setupStatus.type === 'pending' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.ml.steps.setupProcess.loadingText",
    defaultMessage: "Creating ML job..."
  }))) : setupStatus.type === 'failed' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.ml.steps.setupProcess.failureText",
    defaultMessage: "Something went wrong creating the necessary ML jobs."
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), setupStatus.reasons.map((errorMessage, i) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: i
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    title: errorCalloutTitle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    transparentBackground: true
  }, errorMessage)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraJobSetupScreenTryAgainButton",
    fill: true,
    onClick: createJobs
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.ml.steps.setupProcess.tryAgainButton",
    defaultMessage: "Try again"
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.ml.steps.setupProcess.description",
    defaultMessage: "Settings can not be changed once the jobs are created. You can recreate jobs anytime, however, the previously detected anomalies are removed."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.steps.setupProcess.when.title",
      defaultMessage: "When does your model begin?"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.steps.setupProcess.when.description",
      defaultMessage: "By default, machine learning jobs analyze the last 4 weeks of data and continue to run indefinitely."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.steps.setupProcess.when.timePicker.label",
      defaultMessage: "Start date"
    })
  }, /*#__PURE__*/_react.default.createElement(_fixed_datepicker.FixedDatePicker, {
    showTimeSelect: true,
    selected: startDate,
    onChange: updateStart,
    maxDate: now
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.steps.setupProcess.partition.title",
      defaultMessage: "How do you want to partition your data?"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.steps.setupProcess.partition.description",
      defaultMessage: "Partitions enable you to build independent models for groups of data that share similar behavior. For example, you can partition by machine type or cloud availability zone."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.steps.setupProcess.partition.label",
      defaultMessage: "Partition field"
    }),
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: _i18n.i18n.translate('xpack.infra.metricsExplorer.groupByLabel', {
      defaultMessage: 'Everything'
    }),
    "aria-label": _i18n.i18n.translate('xpack.infra.metricsExplorer.groupByAriaLabel', {
      defaultMessage: 'Graph per'
    }),
    fullWidth: true,
    singleSelection: true,
    selectedOptions: partitionField ? partitionField.map(p => ({
      label: p
    })) : undefined,
    options: ((_metricsView$fields = metricsView === null || metricsView === void 0 ? void 0 : metricsView.fields) !== null && _metricsView$fields !== void 0 ? _metricsView$fields : []).filter(f => f.aggregatable && f.type === 'string').map(f => ({
      label: f.name
    })),
    onChange: onPartitionFieldChange,
    isClearable: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.steps.setupProcess.filter.title",
      defaultMessage: "Filter"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.steps.setupProcess.filter.description",
      defaultMessage: "By default, machine learning jobs analyze all of your metric data."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.ml.steps.setupProcess.filter.label",
      defaultMessage: "Filter (optional)"
    })
  }, /*#__PURE__*/_react.default.createElement(_kuery_bar.MetricsExplorerKueryBar, {
    onSubmit: onFilterChange,
    onChange: debouncedOnFilterChange,
    value: filter
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraJobSetupScreenCancelButton",
    onClick: props.closeFlyout
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.ml.steps.setupProcess.cancelButton",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraJobSetupScreenEnableJobsButton",
    fill: true,
    fullWidth: false,
    onClick: createJobs
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.ml.steps.setupProcess.enableButton",
    defaultMessage: "Enable jobs"
  }))))));
};
exports.JobSetupScreen = JobSetupScreen;
const errorCalloutTitle = _i18n.i18n.translate('xpack.infra.ml.steps.setupProcess.errorCalloutTitle', {
  defaultMessage: 'An error occurred'
});