"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInitialConfigurationStep = exports.InitialConfigurationStep = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _analysis_setup_indices_form = require("./analysis_setup_indices_form");
var _analysis_setup_timerange_form = require("./analysis_setup_timerange_form");
var _validation = require("./validation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createInitialConfigurationStep = props => ({
  title: initialConfigurationStepTitle,
  children: /*#__PURE__*/_react.default.createElement(InitialConfigurationStep, props)
});
exports.createInitialConfigurationStep = createInitialConfigurationStep;
const InitialConfigurationStep = ({
  setStartTime,
  setEndTime,
  startTime,
  endTime,
  isValidating,
  validatedIndices,
  setupStatus,
  setValidatedIndices,
  validationErrors = [],
  previousQualityWarnings = []
}) => {
  const disabled = (0, _react.useMemo)(() => !editableFormStatus.includes(setupStatus.type), [setupStatus]);
  const [indexValidationErrors, timeRangeValidationErrors, globalValidationErrors] = (0, _react.useMemo)(() => partitionValidationErrors(validationErrors), [validationErrors]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_analysis_setup_timerange_form.AnalysisSetupTimerangeForm, {
    disabled: disabled,
    setStartTime: setStartTime,
    setEndTime: setEndTime,
    startTime: startTime,
    endTime: endTime,
    validationErrors: timeRangeValidationErrors
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_analysis_setup_indices_form.AnalysisSetupIndicesForm, {
    disabled: disabled,
    indices: validatedIndices,
    isValidating: isValidating,
    onChangeSelectedIndices: setValidatedIndices,
    previousQualityWarnings: previousQualityWarnings,
    validationErrors: indexValidationErrors
  }), /*#__PURE__*/_react.default.createElement(ValidationErrors, {
    errors: globalValidationErrors
  })));
};
exports.InitialConfigurationStep = InitialConfigurationStep;
const editableFormStatus = ['required', 'failed', 'skipped'];
const errorCalloutTitle = _i18n.i18n.translate('xpack.infra.analysisSetup.steps.initialConfigurationStep.errorCalloutTitle', {
  defaultMessage: 'Your index configuration is not valid'
});
const initialConfigurationStepTitle = _i18n.i18n.translate('xpack.infra.analysisSetup.configurationStepTitle', {
  defaultMessage: 'Configuration'
});
const ValidationErrors = ({
  errors
}) => {
  if (errors.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    title: errorCalloutTitle
  }, /*#__PURE__*/_react.default.createElement("ul", null, errors.map((error, i) => /*#__PURE__*/_react.default.createElement("li", {
    key: i
  }, formatValidationError(error))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
const formatValidationError = error => {
  switch (error.error) {
    case 'NETWORK_ERROR':
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.analysisSetup.indicesSelectionNetworkError",
        defaultMessage: "We couldn't load your index configuration"
      });
    case 'TOO_FEW_SELECTED_INDICES':
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.analysisSetup.indicesSelectionTooFewSelectedIndicesDescription",
        defaultMessage: "Select at least one index name."
      });
    default:
      return '';
  }
};
const partitionValidationErrors = validationErrors => validationErrors.reduce(([indicesErrors, timeRangeErrors, otherErrors], error) => {
  if (_validation.validationIndicesErrorRT.is(error)) {
    return [[...indicesErrors, error], timeRangeErrors, otherErrors];
  } else if (_validation.timeRangeValidationErrorRT.is(error)) {
    return [indicesErrors, [...timeRangeErrors, error], otherErrors];
  } else {
    return [indicesErrors, timeRangeErrors, [...otherErrors, error]];
  }
}, [[], [], []]);