"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoData = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoData = ({
  titleText,
  bodyText,
  refetchText,
  onRefetch,
  testString
}) => /*#__PURE__*/_react.default.createElement(CenteredEmptyPrompt, {
  title: /*#__PURE__*/_react.default.createElement("h2", null, titleText),
  titleSize: "m",
  body: /*#__PURE__*/_react.default.createElement("p", null, bodyText),
  actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraNoDataButton",
    iconType: "refresh",
    color: "primary",
    fill: true,
    onClick: onRefetch
  }, refetchText),
  "data-test-subj": testString
});
exports.NoData = NoData;
const CenteredEmptyPrompt = (0, _styled.default)(_eui.EuiEmptyPrompt)`
  align-self: center;
`;