"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchResultItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../constants");
var _mappings_state_context = require("../../../mappings_state_context");
var _lib = require("../../../lib");
var _delete_field_provider = require("../fields/delete_field_provider");
var _listItemStyle = require("../common/listItemStyle");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchResultItem = exports.SearchResultItem = /*#__PURE__*/_react.default.memo(function FieldListItemFlatComponent({
  item: {
    display,
    field
  },
  areActionButtonsVisible,
  isHighlighted,
  isDimmed
}) {
  var _TYPE_DEFINITION$sour, _TYPE_DEFINITION$sour2;
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const {
    source,
    isMultiField
  } = field;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = (0, _listItemStyle.getListItemStyle)(euiTheme);
  const editField = () => {
    dispatch({
      type: 'documentField.editField',
      value: field.id
    });
  };
  const renderActionButtons = () => {
    if (!areActionButtonsVisible) {
      return null;
    }
    const editButtonLabel = _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.editFieldButtonLabel', {
      defaultMessage: 'Edit'
    });
    const deleteButtonLabel = _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.removeFieldButtonLabel', {
      defaultMessage: 'Remove'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      css: styles.actions,
      "data-test-subj": "fieldActions"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: editButtonLabel,
      disableScreenReaderOutput: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "pencil",
      onClick: editField,
      "data-test-subj": "editFieldButton",
      "aria-label": editButtonLabel
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_delete_field_provider.DeleteFieldProvider, null, deleteField => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: deleteButtonLabel,
      disableScreenReaderOutput: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "trash",
      color: "danger",
      onClick: () => deleteField(field),
      "data-test-subj": "removeFieldButton",
      "aria-label": deleteButtonLabel
    })))));
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "fieldsListItem"
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: [styles.field, areActionButtonsVisible && styles.fieldEnabled, isHighlighted && styles.fieldHighlighted, isDimmed && styles.fieldDim]
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.wrapper
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    css: styles.content,
    tabIndex: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "fieldName"
  }, display), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "fieldType"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, isMultiField ? _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.multiFieldBadgeLabel', {
    defaultMessage: '{dataType} multi-field',
    values: {
      dataType: (_TYPE_DEFINITION$sour = (_TYPE_DEFINITION$sour2 = _constants.TYPE_DEFINITION[source.type]) === null || _TYPE_DEFINITION$sour2 === void 0 ? void 0 : _TYPE_DEFINITION$sour2.label) !== null && _TYPE_DEFINITION$sour !== void 0 ? _TYPE_DEFINITION$sour : source.type
    }
  }) : (0, _lib.getTypeLabelFromField)(source))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, renderActionButtons())))));
});
SearchResultItem.displayName = 'SearchResultItem'; // display name required for tests to work with React.memo