"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGuidePanelStepStyles = void 0;
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getGuidePanelStepStyles = (euiTheme, stepStatus) => ({
  stepNumber: (0, _react.css)`
    width: 24px;
    height: 24px;
    border-radius: 50%;
    border: 2px solid
      ${stepStatus === 'inactive' ? euiTheme.colors.borderBasePlain : euiTheme.colors.success};
    font-weight: ${euiTheme.font.weight.medium};
    text-align: center;
    line-height: 1.4;
    color: ${stepStatus === 'inactive' ? euiTheme.colors.textSubdued : euiTheme.colors.textParagraph};
  `,
  stepTitle: (0, _react.css)`
    font-weight: ${euiTheme.font.weight.semiBold};
    color: ${stepStatus === 'inactive' ? euiTheme.colors.textSubdued : euiTheme.colors.textParagraph};
    .euiAccordion-isOpen & {
      color: ${euiTheme.colors.textHeading};
    }
  `,
  description: (0, _react.css)`
    p {
      margin-left: 32px;
      margin-block-end: 0;
    }
    ul {
      padding-left: 28px;
    }
  `
});
exports.getGuidePanelStepStyles = getGuidePanelStepStyles;