"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendCreateEnrollmentAPIKey = sendCreateEnrollmentAPIKey;
exports.sendDeleteOneEnrollmentAPIKey = sendDeleteOneEnrollmentAPIKey;
exports.sendGetEnrollmentAPIKeys = sendGetEnrollmentAPIKeys;
exports.sendGetOneEnrollmentAPIKey = sendGetOneEnrollmentAPIKey;
exports.useGetEnrollmentAPIKeysQuery = useGetEnrollmentAPIKeysQuery;
exports.useGetOneEnrollmentAPIKey = useGetOneEnrollmentAPIKey;
var _reactQuery = require("@kbn/react-query");
var _services = require("../../services");
var _constants = require("../../../common/constants");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetOneEnrollmentAPIKey(keyId) {
  return (0, _use_request.useConditionalRequest)({
    method: 'get',
    path: keyId ? _services.enrollmentAPIKeyRouteService.getInfoPath(keyId) : undefined,
    shouldSendRequest: !!keyId,
    version: _constants.API_VERSIONS.public.v1
  });
}
function sendGetOneEnrollmentAPIKey(keyId, options) {
  return (0, _use_request.sendRequest)({
    method: 'get',
    path: _services.enrollmentAPIKeyRouteService.getInfoPath(keyId),
    version: _constants.API_VERSIONS.public.v1,
    ...options
  });
}
function sendDeleteOneEnrollmentAPIKey(keyId, options) {
  return (0, _use_request.sendRequest)({
    method: 'delete',
    path: _services.enrollmentAPIKeyRouteService.getDeletePath(keyId),
    version: _constants.API_VERSIONS.public.v1,
    ...options
  });
}
function sendGetEnrollmentAPIKeys(query, options) {
  return (0, _use_request.sendRequest)({
    method: 'get',
    path: _services.enrollmentAPIKeyRouteService.getListPath(),
    version: _constants.API_VERSIONS.public.v1,
    query,
    ...options
  });
}
function useGetEnrollmentAPIKeysQuery(query, options) {
  return (0, _reactQuery.useQuery)(['get-enrollment-api-keys', query], () => {
    return (0, _use_request.sendRequestForRq)({
      method: 'get',
      path: _services.enrollmentAPIKeyRouteService.getListPath(),
      version: _constants.API_VERSIONS.public.v1,
      query,
      ...options
    });
  });
}
function sendCreateEnrollmentAPIKey(body) {
  return (0, _use_request.sendRequest)({
    method: 'post',
    path: _services.enrollmentAPIKeyRouteService.getCreatePath(),
    version: _constants.API_VERSIONS.public.v1,
    body
  });
}