"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangelogModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChangelogModal = ({
  changelog,
  isLoading,
  onClose
}) => {
  const changelogText = (0, _utils.formatChangelog)(changelog);
  const changelogModalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    maxWidth: true,
    onClose: onClose,
    "data-test-subj": "integrations.changelogModal",
    "aria-labelledby": changelogModalTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: changelogModalTitleId
  }, 'Changelog')), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 10,
    size: "s",
    isLoading: isLoading,
    contentAriaLabel: "changelog text"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    overflowHeight: 360
  }, changelogText))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.changelogModalCloseBtn",
    defaultMessage: "Close"
  }))));
};
exports.ChangelogModal = ChangelogModal;