"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OrphanedIntegrationPolicyDebugger = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../hooks");
var _ = require("..");
var _code_block = require("./code_block");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchOrphanedPolicies = async () => {
  var _response$data$items, _response$data;
  const response = await (0, _hooks.sendGetOrphanedIntegrationPolicies)();
  if (response.error) {
    throw new Error(response.error.message);
  }
  return (_response$data$items = (_response$data = response.data) === null || _response$data === void 0 ? void 0 : _response$data.items) !== null && _response$data$items !== void 0 ? _response$data$items : [];
};
const OrphanedIntegrationPolicyDebugger = () => {
  var _orphanedPolicies$map;
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [selectedPolicyId, setSelectedPolicyId] = (0, _react.useState)();
  const [isDeleteModalVisible, setIsDeleteModalVisible] = (0, _react.useState)(false);
  const [isDeleteAllModalVisible, setIsDeleteAllModalVisible] = (0, _react.useState)(false);
  const {
    data: orphanedPolicies
  } = (0, _reactQuery.useQuery)(['debug-orphaned-policies'], fetchOrphanedPolicies);
  const comboBoxOptions = (_orphanedPolicies$map = orphanedPolicies === null || orphanedPolicies === void 0 ? void 0 : orphanedPolicies.map(policy => ({
    label: policy.name,
    value: policy.id
  }))) !== null && _orphanedPolicies$map !== void 0 ? _orphanedPolicies$map : [];
  const selectedOptions = selectedPolicyId ? [comboBoxOptions.find(({
    value
  }) => value === selectedPolicyId)] : [];
  const selectedPolicy = orphanedPolicies === null || orphanedPolicies === void 0 ? void 0 : orphanedPolicies.find(policy => policy.id === selectedPolicyId);
  const deleteOnePolicyMutation = (0, _reactQuery.useMutation)(async policyId => {
    const response = await (0, _hooks.sendDeletePackagePolicy)({
      packagePolicyIds: [policyId],
      force: true
    });
    if (response.error) {
      notifications.toasts.addError(response.error, {
        title: _i18n.i18n.translate('xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteError', {
          defaultMessage: 'Error deleting policy'
        }),
        toastMessage: response.error.message
      });
      throw new Error(response.error.message);
    }
    notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteSuccess', {
      defaultMessage: 'Successfully deleted orphaned policy'
    }));
    _.queryClient.invalidateQueries(['debug-orphaned-policies']);
    setSelectedPolicyId(undefined);
    setIsDeleteModalVisible(false);
    return response.data;
  });
  const deleteAllPoliciesMutation = (0, _reactQuery.useMutation)(async () => {
    const response = await (0, _hooks.sendDeletePackagePolicy)({
      packagePolicyIds: orphanedPolicies === null || orphanedPolicies === void 0 ? void 0 : orphanedPolicies.map(policy => policy.id),
      force: true
    });
    if (response.error) {
      notifications.toasts.addError(response.error, {
        title: _i18n.i18n.translate('xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllError', {
          defaultMessage: 'Error deleting orphaned policies'
        }),
        toastMessage: response.error.message
      });
      throw new Error(response.error.message);
    }
    notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllSuccess', {
      defaultMessage: 'Successfully deleted all orphaned policies'
    }));
    _.queryClient.invalidateQueries(['debug-orphaned-policies']);
    setSelectedPolicyId(undefined);
    setIsDeleteAllModalVisible(false);
    return response.data;
  });
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.orphanedIntegrationPolicyDebugger.description",
    defaultMessage: "This tool can be used to delete \"orphaned\" integration policies that have been unlinked from their parent agent policy objects"
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteOptions",
    defaultMessage: "You may delete a single orphaned integration policy or use the \"Delete all\" button to delete all orphaned integration policies at once."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: `
            min-width: 400px;
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.fleet.debug.orphanedIntegrationPolicyDebugger.selectLabel', {
      defaultMessage: 'Select an orphaned integration policy'
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.debug.orphanedIntegrationPolicyDebugger.selectLabel', {
      defaultMessage: 'Select an orphaned integration policy'
    }),
    fullWidth: true,
    options: comboBoxOptions,
    singleSelection: {
      asPlainText: true
    },
    selectedOptions: selectedOptions,
    onChange: newSelectedOptions => {
      if (!newSelectedOptions.length) {
        setSelectedPolicyId(undefined);
      } else {
        setSelectedPolicyId(newSelectedOptions[0].value);
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "warning",
    isDisabled: !selectedPolicyId,
    onClick: () => setIsDeleteModalVisible(true)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteButton",
    defaultMessage: "Delete"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    isDisabled: !(orphanedPolicies !== null && orphanedPolicies !== void 0 && orphanedPolicies.length),
    onClick: () => setIsDeleteAllModalVisible(true)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllButton",
    defaultMessage: "Delete all"
  }))))), isDeleteModalVisible && selectedPolicy && selectedPolicyId && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteModalTitle', {
      defaultMessage: 'Delete {policyName}',
      values: {
        policyName: selectedPolicy.name
      }
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: () => setIsDeleteModalVisible(false),
    onConfirm: () => deleteOnePolicyMutation.mutate(selectedPolicyId),
    isLoading: deleteOnePolicyMutation.isLoading,
    cancelButtonText: _i18n.i18n.translate('xpack.fleet.debug.orphanedIntegrationPolicyDebugger.cancelDelete', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.fleet.debug.orphanedIntegrationPolicyDebugger.confirmDelete', {
      defaultMessage: 'Delete'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteModalBody",
    defaultMessage: "Are you sure you want to delete {policyName}?",
    values: {
      policyName: selectedPolicy.name
    }
  })), isDeleteAllModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllModalTitle', {
      defaultMessage: 'Delete all orphaned integration policies'
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: () => setIsDeleteAllModalVisible(false),
    onConfirm: () => deleteAllPoliciesMutation.mutate(),
    isLoading: deleteAllPoliciesMutation.isLoading,
    cancelButtonText: _i18n.i18n.translate('xpack.fleet.debug.orphanedIntegrationPolicyDebugger.cancelDeleteAll', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.fleet.debug.orphanedIntegrationPolicyDebugger.confirmDeleteAll', {
      defaultMessage: 'Delete all'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllModalBody",
    defaultMessage: "Are you sure you want to delete all orphaned integration policies?"
  })), selectedPolicyId && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_code_block.CodeBlock, {
    value: JSON.stringify(selectedPolicy, null, 2)
  })));
};
exports.OrphanedIntegrationPolicyDebugger = OrphanedIntegrationPolicyDebugger;