"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentActivityButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentActivityButton = ({
  onClickAgentActivity,
  shouldShowTour = false
}) => {
  const {
    isOpen,
    dismiss
  } = (0, _hooks.useDismissableTour)('AGENT_ACTIVITY', shouldShowTour);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentActivityButton.tourContent",
      defaultMessage: "Review in progress, completed, and scheduled agent action activity history here anytime."
    })),
    isStepOpen: isOpen,
    onFinish: dismiss,
    minWidth: 360,
    maxWidth: 360,
    step: 1,
    stepsTotal: 1,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentActivityButton.tourTitle",
      defaultMessage: "Agent activity history"
    }),
    anchorPosition: "upCenter",
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: dismiss
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.genericTourPopover.dismissButton",
      defaultMessage: "Got it"
    })),
    anchor: "#agentActivityButton"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => {
      onClickAgentActivity();
    },
    "data-test-subj": "agentActivityButton",
    iconType: "clock",
    id: "agentActivityButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.agentActivityButton",
    defaultMessage: "Agent activity"
  })));
};
exports.AgentActivityButton = AgentActivityButton;