"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupingFunctionDefinitions = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * __AUTOGENERATED FILE. DO NOT EDIT THIS FILE DIRECTLY.__
 *
 * @note This file is generated by the `generate_function_definitions.ts`
 * script. Do not edit it manually.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const bucketDefinition = {
  type: _types.FunctionDefinitionTypes.GROUPING,
  name: 'bucket',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.bucket', {
    defaultMessage: 'Creates groups of values - buckets - out of a datetime or numeric input.\nThe size of the buckets can either be provided directly, or chosen based on a recommended count and values range.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'buckets',
      type: 'date_period',
      optional: false,
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'date',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'date',
      optional: true,
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'date',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'keyword',
      optional: true,
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'date',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'text',
      optional: true,
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'keyword',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'date',
      optional: true,
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'keyword',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'keyword',
      optional: true,
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'keyword',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'text',
      optional: true,
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'text',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'date',
      optional: true,
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'text',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'keyword',
      optional: true,
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'text',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'text',
      optional: true,
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false
    }, {
      name: 'buckets',
      type: 'time_duration',
      optional: false,
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'buckets',
      type: 'date_period',
      optional: false,
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'date',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'date',
      optional: true,
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'date',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'keyword',
      optional: true,
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'date',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'text',
      optional: true,
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'keyword',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'date',
      optional: true,
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'keyword',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'keyword',
      optional: true,
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'keyword',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'text',
      optional: true,
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'text',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'date',
      optional: true,
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'text',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'keyword',
      optional: true,
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'text',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'text',
      optional: true,
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false
    }, {
      name: 'buckets',
      type: 'time_duration',
      optional: false,
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'buckets',
      type: 'double',
      optional: false,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'double',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'double',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'double',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'integer',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'double',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'integer',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'double',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'integer',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'integer',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'integer',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'long',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'double',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'long',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'integer',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'long',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false
    }, {
      name: 'buckets',
      type: 'long',
      optional: false,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'buckets',
      type: 'double',
      optional: false,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'double',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'double',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'double',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'integer',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'double',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'integer',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'double',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'integer',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'integer',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'integer',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'long',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'double',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'long',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'integer',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'long',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false
    }, {
      name: 'buckets',
      type: 'long',
      optional: false,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'buckets',
      type: 'double',
      optional: false,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'double',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'double',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'double',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'integer',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'double',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'integer',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'double',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'integer',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'integer',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'integer',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'long',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'double',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'long',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'integer',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      constantOnly: true
    }, {
      name: 'from',
      type: 'long',
      optional: true,
      constantOnly: true
    }, {
      name: 'to',
      type: 'long',
      optional: true,
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false
    }, {
      name: 'buckets',
      type: 'long',
      optional: false,
      constantOnly: true
    }],
    returnType: 'double'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.STATS_BY],
  validate: undefined,
  examples: ['FROM employees\n| WHERE hire_date >= "1985-01-01T00:00:00Z" AND hire_date < "1986-01-01T00:00:00Z"\n| STATS hire_date = MV_SORT(VALUES(hire_date)) BY month = BUCKET(hire_date, 20, "1985-01-01T00:00:00Z", "1986-01-01T00:00:00Z")', 'FROM employees\n| WHERE hire_date >= "1985-01-01T00:00:00Z" AND hire_date < "1986-01-01T00:00:00Z"\n| STATS hires_per_month = COUNT(*) BY month = BUCKET(hire_date, 20, "1985-01-01T00:00:00Z", "1986-01-01T00:00:00Z")\n| SORT month', 'FROM employees\n| WHERE hire_date >= "1985-01-01T00:00:00Z" AND hire_date < "1986-01-01T00:00:00Z"\n| STATS hires_per_week = COUNT(*) BY week = BUCKET(hire_date, 100, "1985-01-01T00:00:00Z", "1986-01-01T00:00:00Z")', 'FROM employees\n| WHERE hire_date >= "1985-01-01T00:00:00Z" AND hire_date < "1986-01-01T00:00:00Z"\n| STATS hires_per_week = COUNT(*) BY week = BUCKET(hire_date, 1 week)\n| SORT week', 'FROM employees\n| STATS COUNT(*) by bs = BUCKET(salary, 20, 25324, 74999)\n| SORT bs', 'FROM employees\n| WHERE hire_date >= "1985-01-01T00:00:00Z" AND hire_date < "1986-01-01T00:00:00Z"\n| STATS c = COUNT(1) BY b = BUCKET(salary, 5000.)\n| SORT b', 'FROM sample_data\n| WHERE @timestamp >= NOW() - 1 day and @timestamp < NOW()\n| STATS COUNT(*) BY bucket = BUCKET(@timestamp, 25, NOW() - 1 day, NOW())', 'FROM employees\n| WHERE hire_date >= "1985-01-01T00:00:00Z" AND hire_date < "1986-01-01T00:00:00Z"\n| STATS AVG(salary) BY bucket = BUCKET(hire_date, 20, "1985-01-01T00:00:00Z", "1986-01-01T00:00:00Z")', 'FROM employees\n| STATS s1 = b1 + 1, s2 = BUCKET(salary / 1000 + 999, 50.) + 2 BY b1 = BUCKET(salary / 100 + 99, 50.), b2 = BUCKET(salary / 1000 + 999, 50.)\n| SORT b1, b2\n| KEEP s1, b1, s2, b2', 'FROM employees\n| STATS dates = MV_SORT(VALUES(birth_date)) BY b = BUCKET(birth_date + 1 HOUR, 1 YEAR) - 1 HOUR\n| EVAL d_count = MV_COUNT(dates)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const categorizeDefinition = {
  type: _types.FunctionDefinitionTypes.GROUPING,
  name: 'categorize',
  description: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.definitions.categorize', {
    defaultMessage: 'Groups text messages into categories of similarly formatted text values.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false
    }],
    license: 'PLATINUM',
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false
    }],
    license: 'PLATINUM',
    returnType: 'keyword'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.STATS_BY],
  validate: undefined,
  examples: ['FROM sample_data\n| STATS count=COUNT() BY category=CATEGORIZE(message)']
};
const groupingFunctionDefinitions = exports.groupingFunctionDefinitions = [bucketDefinition, categorizeDefinition];