"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteIndexModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _indices = require("../../utils/indices");
var _indices_logic = require("./indices_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteIndexModal = () => {
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    closeDeleteModal,
    deleteIndex
  } = (0, _kea.useActions)(_indices_logic.IndicesLogic);
  const {
    deleteModalIndexName: indexName,
    deleteModalIndexHasInProgressSyncs,
    deleteModalIngestionMethod: ingestionMethod,
    isDeleteModalVisible,
    isDeleteLoading,
    isFetchIndexDetailsLoading
  } = (0, _kea.useValues)(_indices_logic.IndicesLogic);
  const [inputIndexName, setInputIndexName] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    setInputIndexName('');
  }, [isDeleteModalVisible, indexName]);
  return isDeleteModalVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    titleProps: {
      id: confirmModalTitleId
    },
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.deleteModal.title', {
      defaultMessage: 'Are you sure you want to delete {indexName}',
      values: {
        indexName
      }
    }),
    onCancel: () => {
      closeDeleteModal();
    },
    onConfirm: () => {
      deleteIndex({
        indexName
      });
    },
    cancelButtonText: isDeleteLoading ? _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.deleteModal.closeButton.title', {
      defaultMessage: 'Close'
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.deleteModal.cancelButton.title', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.deleteModal.confirmButton.title', {
      defaultMessage: 'Delete index'
    }),
    defaultFocusedButton: "confirm",
    buttonColor: "danger",
    confirmButtonDisabled: inputIndexName.trim() !== indexName,
    isLoading: isDeleteLoading || isFetchIndexDetailsLoading
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.deleteModal.delete.description', {
    defaultMessage: 'Deleting this index will also delete all of its data and its {ingestionMethod} configuration. Any associated search applications will no longer be able to access any data stored in this index.',
    values: {
      ingestionMethod: (0, _indices.ingestionMethodToText)(ingestionMethod)
    }
  })), deleteModalIndexHasInProgressSyncs && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.deleteModal.syncsWarning.title', {
      defaultMessage: 'Syncs in progress'
    })
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.deleteModal.syncsWarning.description', {
    defaultMessage: 'This index has in-progress syncs. Deleting the index without stopping these syncs may result in dangling sync job records or the index being re-created.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.searchIndices.deleteModal.syncsWarning.indexNameDescription",
    defaultMessage: "This action cannot be undone. Please type {indexName} to confirm.",
    values: {
      indexName: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "danger"
      }, indexName))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.deleteModal.indexNameInput.label', {
      defaultMessage: 'Index name'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "entSearchContent-indices-deleteModal-input",
    "data-telemetry-id": "entSearchContent-indices-deleteModal-input",
    onChange: e => setInputIndexName(e.target.value),
    value: inputIndexName
  })))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
};
exports.DeleteIndexModal = DeleteIndexModal;