"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineSelectLogic = void 0;
var _kea = require("kea");
var _ml_inference_pipeline = require("../../../../../../../common/ml_inference_pipeline");
var _utils = require("../../../shared/ml_inference/utils");
var _ml_inference_logic = require("./ml_inference_logic");
var _utils2 = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PipelineSelectLogic = exports.PipelineSelectLogic = (0, _kea.kea)({
  actions: {
    selectExistingPipeline: pipelineName => ({
      pipelineName
    })
  },
  connect: {
    actions: [_ml_inference_logic.MLInferenceLogic, ['setInferencePipelineConfiguration']],
    values: [_ml_inference_logic.MLInferenceLogic, ['addInferencePipelineModal', 'mlInferencePipelineProcessors', 'mlInferencePipelinesData', 'selectableModels', 'selectedModel', 'sourceFields']]
  },
  path: ['enterprise_search', 'content', 'pipeline_select_logic'],
  listeners: ({
    actions,
    values
  }) => ({
    selectExistingPipeline: ({
      pipelineName
    }) => {
      var _values$mlInferencePi;
      const pipeline = (_values$mlInferencePi = values.mlInferencePipelinesData) === null || _values$mlInferencePi === void 0 ? void 0 : _values$mlInferencePi[pipelineName];
      if (!pipeline) return;
      const params = (0, _ml_inference_pipeline.parseMlInferenceParametersFromPipeline)(pipelineName, pipeline);
      if (params === null) return;
      actions.setInferencePipelineConfiguration({
        existingPipeline: true,
        modelID: params.model_id,
        pipelineName,
        fieldMappings: params.field_mappings,
        targetField: ''
      });
    }
  }),
  selectors: ({
    selectors
  }) => ({
    existingInferencePipelines: [() => [selectors.mlInferencePipelinesData, selectors.sourceFields, selectors.selectableModels, selectors.mlInferencePipelineProcessors], (mlInferencePipelinesData, indexFields, selectableModels, mlInferencePipelineProcessors) => {
      var _mlInferencePipelineP;
      if (!mlInferencePipelinesData) {
        return [];
      }
      const indexProcessorNames = (_mlInferencePipelineP = mlInferencePipelineProcessors === null || mlInferencePipelineProcessors === void 0 ? void 0 : mlInferencePipelineProcessors.map(processor => processor.pipelineName)) !== null && _mlInferencePipelineP !== void 0 ? _mlInferencePipelineP : [];
      const existingPipelines = Object.entries(mlInferencePipelinesData).map(([pipelineName, pipeline]) => {
        var _fieldMappings$map, _sourceFields$filter;
        if (!pipeline || indexProcessorNames.includes(pipelineName)) return undefined;

        // Parse configuration from pipeline definition
        const pipelineParams = (0, _ml_inference_pipeline.parseMlInferenceParametersFromPipeline)(pipelineName, pipeline);
        if (!pipelineParams) return undefined;
        const {
          model_id: modelId,
          field_mappings: fieldMappings
        } = pipelineParams;
        const sourceFields = (_fieldMappings$map = fieldMappings === null || fieldMappings === void 0 ? void 0 : fieldMappings.map(m => m.sourceField)) !== null && _fieldMappings$map !== void 0 ? _fieldMappings$map : [];
        const missingSourceFields = (_sourceFields$filter = sourceFields.filter(f => !(indexFields !== null && indexFields !== void 0 && indexFields.includes(f)))) !== null && _sourceFields$filter !== void 0 ? _sourceFields$filter : [];
        const mlModel = selectableModels.find(model => model.modelId === modelId);
        const modelType = mlModel ? (0, _utils.getMLType)(mlModel.types) : '';
        const disabledReason = missingSourceFields.length > 0 ? (0, _utils2.EXISTING_PIPELINE_DISABLED_MISSING_SOURCE_FIELDS)(missingSourceFields.join(', ')) : undefined;
        return {
          disabled: disabledReason !== undefined,
          disabledReason,
          modelId,
          modelType,
          pipelineName,
          sourceFields,
          indexFields: indexFields !== null && indexFields !== void 0 ? indexFields : []
        };
      }).filter(p => p !== undefined);
      return existingPipelines;
    }]
  })
});