"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorNameAndDescriptionFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _api = require("../../../../../../../common/types/api");
var _constants = require("../../../../../shared/constants");
var _update_connector_name_and_description_api_logic = require("../../../../api/connector/update_connector_name_and_description_api_logic");
var _connector_name_and_description_form_content = require("./connector_name_and_description_form_content");
var _connector_name_and_description_logic = require("./connector_name_and_description_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorNameAndDescriptionFlyout = () => {
  const {
    status
  } = (0, _kea.useValues)(_update_connector_name_and_description_api_logic.ConnectorNameAndDescriptionApiLogic);
  const {
    isEditing
  } = (0, _kea.useValues)(_connector_name_and_description_logic.ConnectorNameAndDescriptionLogic);
  const {
    saveNameAndDescription,
    setIsEditing
  } = (0, _kea.useActions)(_connector_name_and_description_logic.ConnectorNameAndDescriptionLogic);
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  if (!isEditing) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => setIsEditing(false),
    size: "s",
    "aria-labelledby": flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: flyoutTitleId
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nameAndDescriptionFlyout.title', {
    defaultMessage: 'Describe this crawler'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nameAndDescriptionFlyout.description', {
    defaultMessage: 'By naming and describing this connector your colleagues and wider team will know what this connector is meant for.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_connector_name_and_description_form_content.ConnectorNameAndDescriptionFormContent, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => setIsEditing(false),
    isLoading: status === _api.Status.LOADING
  }, _constants.CANCEL_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: status === _api.Status.LOADING,
    fill: true,
    onClick: saveNameAndDescription
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nameAndDescriptionFlyout.saveButtonLabel', {
    defaultMessage: 'Save name and description'
  }))))));
};
exports.ConnectorNameAndDescriptionFlyout = ConnectorNameAndDescriptionFlyout;