"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeneratedConfigFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../common/constants");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _routes = require("../../../routes");
var _connector_view_search_indices_details = require("../../shared/connector_view_search_indices_details/connector_view_search_indices_details");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmModal = ({
  onCancel,
  onConfirm
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.apiKey.confirmModal.title', {
      defaultMessage: 'Generate an Elasticsearch API key'
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.apiKey.confirmModal.cancelButton.label', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.apiKey.confirmModal.confirmButton.label', {
      defaultMessage: 'Generate API key'
    }),
    defaultFocusedButton: "confirm"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.apiKey.confirmModal.description', {
    defaultMessage: 'Generating a new API key will invalidate the previous key. Are you sure you want to generate a new API key? This can not be undone.'
  }));
};
const GeneratedConfigFields = ({
  apiKey,
  connector,
  generateApiKey,
  isGenerateLoading
}) => {
  const apiKeyContainerRef = (0, _react.useRef)(null);
  const restoreFocusRef = (0, _react.useRef)(null);
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const refreshButtonClick = () => {
    restoreFocusRef.current = document.activeElement;
    setIsModalVisible(true);
  };
  const restoreFocus = () => {
    if (!restoreFocusRef.current || restoreFocusRef.current.disabled) {
      var _apiKeyContainerRef$c;
      (_apiKeyContainerRef$c = apiKeyContainerRef.current) === null || _apiKeyContainerRef$c === void 0 ? void 0 : _apiKeyContainerRef$c.focus();
      return;
    } else {
      var _restoreFocusRef$curr;
      (_restoreFocusRef$curr = restoreFocusRef.current) === null || _restoreFocusRef$curr === void 0 ? void 0 : _restoreFocusRef$curr.focus();
    }
    restoreFocusRef.current = null;
  };
  const onCancel = () => {
    setIsModalVisible(false);
  };
  const onConfirm = () => {
    if (generateApiKey) generateApiKey();
    setIsModalVisible(false);
    (0, _lodash.defer)(restoreFocus);
  };
  const showApiKeyInfoForSelfManagedConnector = !connector.is_native;
  const showApiKeyBanner = showApiKeyInfoForSelfManagedConnector && (apiKey === null || apiKey === void 0 ? void 0 : apiKey.encoded);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isModalVisible && /*#__PURE__*/_react.default.createElement(ConfirmModal, {
    onCancel: onCancel,
    onConfirm: onConfirm
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3,
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "check"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorDeployment.connectorCreatedFlexItemLabel', {
    defaultMessage: 'Connector created'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    external: true,
    target: "_blank",
    to: (0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_PATH, {
      connectorId: connector.id
    })
  }, connector.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    justifyContent: "flexEnd",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    external: true,
    target: "_blank",
    to: (0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_PATH, {
      connectorId: connector.id
    })
  }, connector.id)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: connector.id
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    "data-test-subj": "enterpriseSearchConnectorDeploymentButton",
    iconType: "copyClipboard",
    onClick: copy,
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.connectorDeployment.copyConnectorId', {
      defaultMessage: 'Copy connector ID'
    })
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "check"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorDeployment.indexCreatedFlexItemLabel', {
    defaultMessage: 'Index created'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, connector.index_name && /*#__PURE__*/_react.default.createElement(_connector_view_search_indices_details.ConnectorViewIndexLink, {
    indexName: connector.index_name,
    target: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), showApiKeyInfoForSelfManagedConnector && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "check"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _i18n.i18n.translate('xpack.enterpriseSearch.connectorDeployment.apiKeyCreatedFlexItemLabel', {
    defaultMessage: 'API key created'
  }), (apiKey === null || apiKey === void 0 ? void 0 : apiKey.encoded) && ` *`))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "enterpriseSearchConnectorDeploymentLink",
    href: (0, _encode_path_params.generateEncodedPath)(_constants.MANAGE_API_KEYS_URL, {}),
    external: true,
    target: "_blank"
  }, apiKey === null || apiKey === void 0 ? void 0 : apiKey.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    justifyContent: "flexEnd",
    alignItems: "center",
    ref: apiKeyContainerRef,
    tabIndex: -1
  }, apiKey !== null && apiKey !== void 0 && apiKey.encoded ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: apiKey === null || apiKey === void 0 ? void 0 : apiKey.encoded
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, apiKey === null || apiKey === void 0 ? void 0 : apiKey.encoded)), generateApiKey && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "enterpriseSearchGeneratedConfigFieldsButton",
    size: "xs",
    iconType: "refresh",
    isLoading: isGenerateLoading,
    onClick: refreshButtonClick,
    disabled: !connector.index_name,
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.connectorDeployment.refreshAPIKey', {
      defaultMessage: 'Refresh an Elasticsearch API key'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    "data-test-subj": "enterpriseSearchConnectorDeploymentButton",
    iconType: "copyClipboard",
    onClick: copy,
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.connectorDeployment.copyIndexName', {
      defaultMessage: 'Copy index name'
    })
  }))))) : generateApiKey && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "enterpriseSearchGeneratedConfigFieldsButton",
    size: "xs",
    iconType: "refresh",
    isLoading: isGenerateLoading,
    onClick: refreshButtonClick,
    disabled: !connector.index_name,
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.connectorDeployment.generateAPIKey', {
      defaultMessage: 'Generate an Elasticsearch API key'
    })
  })))))), showApiKeyBanner && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "success",
    size: "s",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.connectorDeployment.generatedConfigCallout', {
      defaultMessage: `You'll only see this API key once, so save it somewhere safe. We don't store your API keys, so if you lose a key you'll need to generate a replacement`
    }),
    iconType: "asterisk"
  }))));
};
exports.GeneratedConfigFields = GeneratedConfigFields;