"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnonymizedEvents = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _queries = require("./queries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAnonymizedEvents = async ({
  insightType,
  endpointIds,
  anonymizationFields,
  esClient,
  onNewReplacements,
  replacements,
  size,
  start,
  end
}) => {
  var _result$aggregations$, _result$aggregations;
  if (insightType == null) {
    return [];
  }
  const query = (0, _queries.getQuery)(insightType, {
    endpointIds,
    size,
    gte: start,
    lte: end
  });
  // TODO add support for other insight types
  const result = await esClient.search(query);
  const fileEvents = ((_result$aggregations$ = (_result$aggregations = result.aggregations) === null || _result$aggregations === void 0 ? void 0 : _result$aggregations.unique_process_executable.buckets) !== null && _result$aggregations$ !== void 0 ? _result$aggregations$ : []).map(bucket => {
    const latestEvent = bucket.latest_event.hits.hits[0];
    return {
      _id: [latestEvent._id],
      'agent.id': [latestEvent._source.agent.id],
      'process.executable': [latestEvent._source.process.executable]
    };
  });
  let localReplacements = {
    ...(replacements !== null && replacements !== void 0 ? replacements : {})
  };
  const localOnNewReplacements = newReplacements => {
    localReplacements = {
      ...localReplacements,
      ...newReplacements
    };
    onNewReplacements === null || onNewReplacements === void 0 ? void 0 : onNewReplacements(localReplacements); // invoke the callback with the latest replacements
  };
  return fileEvents.map(event => (0, _elasticAssistantCommon.transformRawData)({
    anonymizationFields,
    currentReplacements: localReplacements,
    // <-- the latest local replacements
    getAnonymizedValue: _elasticAssistantCommon.getAnonymizedValue,
    onNewReplacements: localOnNewReplacements,
    // <-- the local callback
    rawData: (0, _elasticAssistantCommon.getRawDataOrDefault)(event)
  }));
};
exports.getAnonymizedEvents = getAnonymizedEvents;