"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuntimeState = exports.useCurrentTabRuntimeState = exports.useCurrentDataView = exports.useAdHocDataViews = exports.selectTabRuntimeState = exports.selectTabRuntimeGlobalState = exports.selectTabRuntimeAppState = exports.createTabRuntimeState = exports.createRuntimeStateManager = exports.RuntimeStateProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _hooks = require("./hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createRuntimeStateManager = () => ({
  adHocDataViews$: new _rxjs.BehaviorSubject([]),
  tabs: {
    byId: {}
  }
});
exports.createRuntimeStateManager = createRuntimeStateManager;
const createTabRuntimeState = ({
  profilesManager,
  ebtManager
}) => {
  const scopedEbtManager = ebtManager.createScopedEBTManager();
  return {
    stateContainer$: new _rxjs.BehaviorSubject(undefined),
    customizationService$: new _rxjs.BehaviorSubject(undefined),
    unifiedHistogramLayoutProps$: new _rxjs.BehaviorSubject(undefined),
    scopedProfilesManager$: new _rxjs.BehaviorSubject(profilesManager.createScopedProfilesManager({
      scopedEbtManager
    })),
    scopedEbtManager$: new _rxjs.BehaviorSubject(scopedEbtManager),
    currentDataView$: new _rxjs.BehaviorSubject(undefined)
  };
};
exports.createTabRuntimeState = createTabRuntimeState;
const useRuntimeState = stateSubject$ => (0, _useObservable.default)(stateSubject$, stateSubject$.getValue());
exports.useRuntimeState = useRuntimeState;
const selectTabRuntimeState = (runtimeStateManager, tabId) => runtimeStateManager.tabs.byId[tabId];
exports.selectTabRuntimeState = selectTabRuntimeState;
const selectTabRuntimeAppState = (runtimeStateManager, tabId) => {
  var _tabRuntimeState$stat, _tabRuntimeState$stat2;
  const tabRuntimeState = selectTabRuntimeState(runtimeStateManager, tabId);
  return tabRuntimeState === null || tabRuntimeState === void 0 ? void 0 : (_tabRuntimeState$stat = tabRuntimeState.stateContainer$.getValue()) === null || _tabRuntimeState$stat === void 0 ? void 0 : (_tabRuntimeState$stat2 = _tabRuntimeState$stat.appState) === null || _tabRuntimeState$stat2 === void 0 ? void 0 : _tabRuntimeState$stat2.getState();
};
exports.selectTabRuntimeAppState = selectTabRuntimeAppState;
const selectTabRuntimeGlobalState = (runtimeStateManager, tabId) => {
  var _tabRuntimeState$stat3, _tabRuntimeState$stat4;
  const tabRuntimeState = selectTabRuntimeState(runtimeStateManager, tabId);
  const globalState = tabRuntimeState === null || tabRuntimeState === void 0 ? void 0 : (_tabRuntimeState$stat3 = tabRuntimeState.stateContainer$.getValue()) === null || _tabRuntimeState$stat3 === void 0 ? void 0 : (_tabRuntimeState$stat4 = _tabRuntimeState$stat3.globalState) === null || _tabRuntimeState$stat4 === void 0 ? void 0 : _tabRuntimeState$stat4.get();
  if (!globalState) {
    return undefined;
  }
  const {
    time: timeRange,
    refreshInterval,
    filters
  } = globalState;
  return {
    timeRange,
    refreshInterval,
    filters
  };
};
exports.selectTabRuntimeGlobalState = selectTabRuntimeGlobalState;
const useCurrentTabRuntimeState = (runtimeStateManager, selector) => {
  const {
    currentTabId
  } = (0, _hooks.useCurrentTabContext)();
  return useRuntimeState(selector(selectTabRuntimeState(runtimeStateManager, currentTabId)));
};
exports.useCurrentTabRuntimeState = useCurrentTabRuntimeState;
const runtimeStateContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const RuntimeStateProvider = ({
  currentDataView,
  adHocDataViews,
  children
}) => {
  const runtimeState = (0, _react.useMemo)(() => ({
    currentDataView,
    adHocDataViews
  }), [adHocDataViews, currentDataView]);
  return /*#__PURE__*/_react.default.createElement(runtimeStateContext.Provider, {
    value: runtimeState
  }, children);
};
exports.RuntimeStateProvider = RuntimeStateProvider;
const useRuntimeStateContext = () => {
  const context = (0, _react.useContext)(runtimeStateContext);
  if (!context) {
    throw new Error('useRuntimeStateContext must be used within a RuntimeStateProvider');
  }
  return context;
};
const useCurrentDataView = () => useRuntimeStateContext().currentDataView;
exports.useCurrentDataView = useCurrentDataView;
const useAdHocDataViews = () => useRuntimeStateContext().adHocDataViews;
exports.useAdHocDataViews = useAdHocDataViews;