"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchAndValidate$ = fetchAndValidate$;
var _rxjs = require("rxjs");
var _is_valid_search = require("../../../../common/options_list/is_valid_search");
var _options_list_fetch_cache = require("./options_list_fetch_cache");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function fetchAndValidate$({
  api,
  requestSize$,
  runPastTimeout$,
  selectedOptions$,
  searchTechnique$,
  sort$,
  controlFetch$
}) {
  const requestCache = new _options_list_fetch_cache.OptionsListFetchCache();
  let abortController;
  return (0, _rxjs.combineLatest)([api.dataViews$, api.field$, controlFetch$(requestCache.clearCache), api.parentApi.allowExpensiveQueries$, api.parentApi.ignoreParentSettings$, api.debouncedSearchString, sort$, searchTechnique$,
  // cannot use requestSize directly, because we need to be able to reset the size to the default without refetching
  api.loadMoreSubject.pipe((0, _rxjs.startWith)(null),
  // start with null so that `combineLatest` subscription fires
  (0, _rxjs.debounceTime)(100) // debounce load more so "loading" state briefly shows
  )]).pipe((0, _rxjs.tap)(() => {
    // abort any in progress requests
    if (abortController) {
      abortController.abort();
      abortController = undefined;
    }
  }), (0, _rxjs.withLatestFrom)(requestSize$, runPastTimeout$, selectedOptions$), (0, _rxjs.switchMap)(async ([[dataViews, field, controlFetchContext, allowExpensiveQueries, ignoreParentSettings, searchString, sort, searchTechnique], requestSize, runPastTimeout, selectedOptions]) => {
    const dataView = dataViews === null || dataViews === void 0 ? void 0 : dataViews[0];
    if (!dataView || !field || !(0, _is_valid_search.isValidSearch)({
      searchString,
      fieldType: field.type,
      searchTechnique
    })) {
      return {
        suggestions: []
      };
    }

    /** Fetch the suggestions list + perform validation */
    api.loadingSuggestions$.next(true);
    const request = {
      sort,
      dataView,
      searchString,
      runPastTimeout,
      searchTechnique,
      selectedOptions,
      field: field.toSpec(),
      size: requestSize,
      allowExpensiveQueries,
      ignoreValidations: ignoreParentSettings === null || ignoreParentSettings === void 0 ? void 0 : ignoreParentSettings.ignoreValidations,
      ...controlFetchContext
    };
    const newAbortController = new AbortController();
    abortController = newAbortController;
    try {
      return await requestCache.runFetchRequest(request, newAbortController.signal);
    } catch (error) {
      return {
        error
      };
    }
  }), (0, _rxjs.tap)(() => {
    api.loadingSuggestions$.next(false);
  }));
}