"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReorderableTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _body_row = require("./body_row");
var _body_rows = require("./body_rows");
var _draggable_body_row = require("./draggable_body_row");
var _draggable_body_rows = require("./draggable_body_rows");
var _header_row = require("./header_row");
var Styles = _interopRequireWildcard(require("./styles"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReorderableTable = ({
  ariaLabel = 'Reorderable table',
  bottomRows = [],
  className = '',
  columns,
  disableDragging = false,
  disableReordering = false,
  items,
  noItemsMessage,
  onReorder = () => undefined,
  rowErrors = () => undefined,
  rowProps = () => ({}),
  showRowIndex = false,
  unreorderableItems = []
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  // Calculate row index offset (header row = 1)
  const rowIndexOffset = 2; // Start body rows at index 2

  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)(className),
    css: Styles.reorderableTableStyles(euiTheme),
    role: "table",
    "aria-label": ariaLabel
  }, /*#__PURE__*/_react.default.createElement(_header_row.HeaderRow, {
    columns: columns,
    leftAction: disableReordering ? undefined : /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.contentConnectors.reorderableTable.grabHandleScreenReaderOnlyLabel', {
      defaultMessage: 'Grab handle'
    }))),
    spacingForRowIdentifier: showRowIndex
  }), items.length === 0 && unreorderableItems.length === 0 && bottomRows.length === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "NoItems",
    className: "reorderableTableNoItems"
  }, noItemsMessage)), items.length > 0 && disableReordering && /*#__PURE__*/_react.default.createElement(_body_rows.BodyRows, {
    items: items,
    renderItem: (item, itemIndex) => /*#__PURE__*/_react.default.createElement(_body_row.BodyRow, {
      key: `table_draggable_row_${itemIndex}`,
      columns: columns,
      item: item,
      additionalProps: rowProps(item),
      errors: rowErrors(item),
      rowIdentifier: showRowIndex ? `${itemIndex + 1}` : undefined,
      ariaRowindex: itemIndex + rowIndexOffset
    })
  }), items.length > 0 && !disableReordering && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_draggable_body_rows.DraggableBodyRows, {
    items: items,
    renderItem: (item, itemIndex) => /*#__PURE__*/_react.default.createElement(_draggable_body_row.DraggableBodyRow, {
      key: `table_draggable_row_${itemIndex}`,
      columns: columns,
      item: item,
      additionalProps: rowProps(item),
      disableDragging: disableDragging,
      rowIndex: itemIndex,
      errors: rowErrors(item),
      rowIdentifier: showRowIndex ? `${itemIndex + 1}` : undefined,
      ariaRowindex: itemIndex + rowIndexOffset
    }),
    onReorder: onReorder
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "unorderableRows"
  }, unreorderableItems.length > 0 && /*#__PURE__*/_react.default.createElement(_body_rows.BodyRows, {
    items: unreorderableItems,
    renderItem: (item, itemIndex) => {
      const rowIndex = items.length + itemIndex + rowIndexOffset;
      return /*#__PURE__*/_react.default.createElement(_body_row.BodyRow, {
        key: `table_draggable_row_${itemIndex}`,
        columns: columns,
        item: item,
        additionalProps: rowProps(item),
        errors: rowErrors(item),
        leftAction: disableReordering ? undefined : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " "),
        rowIdentifier: showRowIndex ? '∞' : undefined,
        ariaRowindex: rowIndex
      });
    }
  }), bottomRows.map((row, rowIndex) => {
    const ariaRowIndex = items.length + unreorderableItems.length + rowIndex + rowIndexOffset;
    return /*#__PURE__*/_react.default.createElement(_body_row.BodyRow // Shoving a generic ReactNode into a BodyRow is kind of a hack
    , {
      key: rowIndex,
      rowIdentifier: showRowIndex ? '∞' : undefined,
      columns: [{
        render: () => row
      }],
      item: {},
      leftAction: disableReordering ? undefined : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " "),
      "data-test-subj": "BottomRow",
      ariaRowindex: ariaRowIndex
    });
  })));
};
exports.ReorderableTable = ReorderableTable;