"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexTemplate = getIndexTemplate;
var _elasticsearch = require("@elastic/elasticsearch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getIndexTemplate(esClient, params) {
  try {
    return await esClient.indices.getIndexTemplate(params, {
      signal: new AbortController().signal
    });
  } catch (e) {
    if (e instanceof _elasticsearch.errors.ResponseError && e.statusCode === 404) {
      return {
        index_templates: []
      };
    }
    throw e;
  }
}