"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditDiscoveryRule = EditDiscoveryRule;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EditDiscoveryRule({
  id,
  onChangeOperation,
  operation,
  onChangeType,
  type,
  onChangeProbe,
  probe,
  onCancel,
  onSubmit,
  operationTypes
}) {
  var _operationTypes$find$, _operationTypes$find;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    legend: {
      children: _i18n.i18n.translate('xpack.apm.fleetIntegration.apmAgent.editDisacoveryRule.operation', {
        defaultMessage: 'Operation'
      })
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "apmEditDiscoveryRuleSelect",
    options: operationTypes.map(item => ({
      text: item.operation.label,
      value: item.operation.value
    })),
    value: operation,
    onChange: e => {
      onChangeOperation(e.target.value);
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    legend: {
      children: _i18n.i18n.translate('xpack.apm.fleetIntegration.apmAgent.editDisacoveryRule.type', {
        defaultMessage: 'Type'
      })
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.apm.fleetIntegration.apmAgent.runtimeAttachment.editRule.helpText', {
      defaultMessage: 'Choose from allowed parameters'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    hasDividers: true,
    fullWidth: true,
    options: (_operationTypes$find$ = (_operationTypes$find = operationTypes.find(({
      operation: definedOperation
    }) => definedOperation.value === operation)) === null || _operationTypes$find === void 0 ? void 0 : _operationTypes$find.types.map(item => ({
      inputDisplay: item.label,
      value: item.value,
      dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, item.label), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("p", null, item.description)))
    }))) !== null && _operationTypes$find$ !== void 0 ? _operationTypes$find$ : [],
    valueOfSelected: type,
    onChange: onChangeType
  }))))), type !== _.DISCOVERY_RULE_TYPE_ALL && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    legend: {
      children: _i18n.i18n.translate('xpack.apm.fleetIntegration.apmAgent.editDisacoveryRule.probe', {
        defaultMessage: 'Probe'
      })
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.apm.fleetIntegration.apmAgent.runtimeAttachment.editRule.probeValue', {
      defaultMessage: 'Enter the probe value'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "apmEditDiscoveryRuleFieldText",
    fullWidth: true,
    value: probe,
    onChange: e => onChangeProbe(e.target.value)
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmEditDiscoveryRuleCancelButton",
    onClick: onCancel
  }, "Cancel")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmEditDiscoveryRuleButton",
    onClick: onSubmit,
    fill: true,
    disabled: type === _.DISCOVERY_RULE_TYPE_ALL ? false : probe === ''
  }, id === _.STAGED_DISCOVERY_RULE_ID ? _i18n.i18n.translate('xpack.apm.fleetIntegration.apmAgent.runtimeAttachment.editRule.add', {
    defaultMessage: 'Add'
  }) : _i18n.i18n.translate('xpack.apm.fleetIntegration.apmAgent.runtimeAttachment.editRule.save', {
    defaultMessage: 'Save'
  })))));
}