"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardSelector = DashboardSelector;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _url_helpers = require("../../shared/links/url_helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DashboardSelector({
  serviceDashboards,
  currentDashboardId,
  setCurrentDashboard
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const [selectedDashboard, setSelectedDashboard] = (0, _react.useState)();
  (0, _useMount.default)(() => {
    if (!currentDashboardId) {
      history.push({
        ...history.location,
        search: (0, _url_helpers.fromQuery)({
          ...(0, _url_helpers.toQuery)(location.search),
          dashboardId: serviceDashboards[0].dashboardSavedObjectId
        })
      });
    }
  });
  (0, _react.useEffect)(() => {
    const preselectedDashboard = serviceDashboards.find(({
      dashboardSavedObjectId
    }) => dashboardSavedObjectId === currentDashboardId);
    // preselect dashboard
    if (preselectedDashboard) {
      setSelectedDashboard(preselectedDashboard);
      setCurrentDashboard(preselectedDashboard);
    }
  }, [serviceDashboards, currentDashboardId, setCurrentDashboard]);
  function onChange(newDashboardId) {
    history.push({
      ...history.location,
      search: (0, _url_helpers.fromQuery)({
        ...(0, _url_helpers.toQuery)(location.search),
        dashboardId: newDashboardId
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    compressed: true,
    style: {
      minWidth: '200px'
    },
    placeholder: _i18n.i18n.translate('xpack.apm.serviceDashboards.selectDashboard.placeholder', {
      defaultMessage: 'Select dashboard'
    }),
    prepend: _i18n.i18n.translate('xpack.apm.serviceDashboards.selectDashboard.prepend', {
      defaultMessage: 'Dashboard'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: serviceDashboards.map(({
      dashboardSavedObjectId,
      title
    }) => {
      return {
        label: title,
        value: dashboardSavedObjectId
      };
    }),
    selectedOptions: selectedDashboard ? [{
      value: selectedDashboard.dashboardSavedObjectId,
      label: selectedDashboard.title
    }] : [],
    onChange: ([newItem]) => onChange(newItem.value),
    isClearable: false
  });
}