/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;

public class TransformMetadata
implements Metadata.ProjectCustom {
    public static final String TYPE = "transform";
    public static final ParseField RESET_MODE = new ParseField("reset_mode", new String[0]);
    public static final ParseField UPGRADE_MODE = new ParseField("upgrade_mode", new String[0]);
    public static final TransformMetadata EMPTY_METADATA = new TransformMetadata(false, false);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = new ObjectParser("transform_metadata", true, Builder::new);
    private final boolean resetMode;
    private final boolean upgradeMode;

    private TransformMetadata(boolean resetMode, boolean upgradeMode) {
        this.resetMode = resetMode;
        this.upgradeMode = upgradeMode;
    }

    public boolean resetMode() {
        return this.resetMode;
    }

    public boolean upgradeMode() {
        return this.upgradeMode;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    public String getWriteableName() {
        return TYPE;
    }

    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    public Diff<Metadata.ProjectCustom> diff(Metadata.ProjectCustom previousState) {
        return new TransformMetadataDiff((TransformMetadata)previousState, this);
    }

    public TransformMetadata(StreamInput in) throws IOException {
        this.resetMode = in.readBoolean();
        this.upgradeMode = in.getTransportVersion().supports(TransportVersions.V_8_18_0) ? in.readBoolean() : false;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.resetMode);
        if (out.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            out.writeBoolean(this.upgradeMode);
        }
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.single((builder, params) -> builder.field(UPGRADE_MODE.getPreferredName(), this.upgradeMode).field(RESET_MODE.getPreferredName(), this.resetMode));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformMetadata that = (TransformMetadata)o;
        return this.resetMode == that.resetMode && this.upgradeMode == that.upgradeMode;
    }

    public final String toString() {
        return Strings.toString((ChunkedToXContent)this);
    }

    public int hashCode() {
        return Objects.hash(this.resetMode, this.upgradeMode);
    }

    public Builder builder() {
        return new Builder(this);
    }

    @Deprecated(forRemoval=true)
    public static TransformMetadata getTransformMetadata(ClusterState state) {
        TransformMetadata TransformMetadata2;
        TransformMetadata transformMetadata = TransformMetadata2 = state == null ? null : (TransformMetadata)state.metadata().getSingleProjectCustom(TYPE);
        if (TransformMetadata2 == null) {
            return EMPTY_METADATA;
        }
        return TransformMetadata2;
    }

    public static boolean upgradeMode(ClusterState state) {
        return TransformMetadata.getTransformMetadata(state).upgradeMode();
    }

    static {
        LENIENT_PARSER.declareBoolean(Builder::resetMode, RESET_MODE);
        LENIENT_PARSER.declareBoolean(Builder::upgradeMode, UPGRADE_MODE);
    }

    public static class TransformMetadataDiff
    implements NamedDiff<Metadata.ProjectCustom> {
        final boolean resetMode;
        final boolean upgradeMode;

        TransformMetadataDiff(TransformMetadata before, TransformMetadata after) {
            this.resetMode = after.resetMode;
            this.upgradeMode = after.upgradeMode;
        }

        public TransformMetadataDiff(StreamInput in) throws IOException {
            this.resetMode = in.readBoolean();
            this.upgradeMode = in.getTransportVersion().supports(TransportVersions.V_8_18_0) ? in.readBoolean() : false;
        }

        public Metadata.ProjectCustom apply(Metadata.ProjectCustom part) {
            return new TransformMetadata(this.resetMode, this.upgradeMode);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.resetMode);
            if (out.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
                out.writeBoolean(this.upgradeMode);
            }
        }

        public String getWriteableName() {
            return TransformMetadata.TYPE;
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersion.minimumCompatible();
        }
    }

    public static class Builder {
        private boolean resetMode;
        private boolean upgradeMode;

        public static Builder from(@Nullable TransformMetadata previous) {
            return new Builder(previous);
        }

        public Builder() {
        }

        public Builder(@Nullable TransformMetadata previous) {
            if (previous != null) {
                this.resetMode = previous.resetMode;
                this.upgradeMode = previous.upgradeMode;
            }
        }

        public Builder resetMode(boolean isResetMode) {
            this.resetMode = isResetMode;
            return this;
        }

        public Builder upgradeMode(boolean upgradeMode) {
            this.upgradeMode = upgradeMode;
            return this;
        }

        public TransformMetadata build() {
            return new TransformMetadata(this.resetMode, this.upgradeMode);
        }
    }
}

