/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.StoredFieldIndexFieldData;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public abstract class StoredFieldSortedBinaryIndexFieldData
extends StoredFieldIndexFieldData<SortedBinaryDocValues> {
    protected StoredFieldSortedBinaryIndexFieldData(String fieldName, ValuesSourceType valuesSourceType, ToScriptFieldFactory<SortedBinaryDocValues> toScriptFieldFactory) {
        super(fieldName, valuesSourceType, toScriptFieldFactory);
    }

    @Override
    protected SourceValueFetcherSortedBinaryDocValues loadLeaf(LeafStoredFieldLoader leafStoredFieldLoader) {
        return new SourceValueFetcherSortedBinaryDocValues(leafStoredFieldLoader);
    }

    protected abstract BytesRef storedToBytesRef(Object var1);

    class SourceValueFetcherSortedBinaryDocValues
    extends SortedBinaryDocValues {
        private final LeafStoredFieldLoader loader;
        private final List<BytesRef> sorted = new ArrayList<BytesRef>();
        private int current;
        private int docValueCount;

        SourceValueFetcherSortedBinaryDocValues(LeafStoredFieldLoader loader) {
            this.loader = loader;
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            this.loader.advanceTo(doc);
            List<Object> values = this.loader.storedFields().get(StoredFieldSortedBinaryIndexFieldData.this.getFieldName());
            if (values == null || values.isEmpty()) {
                this.current = 0;
                this.docValueCount = 0;
                return false;
            }
            this.sorted.clear();
            for (Object o : values) {
                this.sorted.add(StoredFieldSortedBinaryIndexFieldData.this.storedToBytesRef(o));
            }
            Collections.sort(this.sorted);
            this.current = 0;
            this.docValueCount = this.sorted.size();
            return true;
        }

        @Override
        public int docValueCount() {
            return this.docValueCount;
        }

        @Override
        public BytesRef nextValue() {
            assert (this.current < this.docValueCount);
            return this.sorted.get(this.current++);
        }
    }
}

