/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import org.apache.lucene.util.StringHelper;
import org.elasticsearch.common.util.ByteUtils;

public final class Murmur3HashFunction {
    private static final int MAX_SCRATCH_SIZE = 1024;
    private static final ThreadLocal<byte[]> scratch = ThreadLocal.withInitial(() -> new byte[1024]);

    private Murmur3HashFunction() {
    }

    public static int hash(String routing) {
        assert (Murmur3HashFunction.assertHashWithoutInformationLoss(routing));
        int strLen = routing.length();
        byte[] bytesToHash = strLen * 2 <= 1024 ? scratch.get() : new byte[strLen * 2];
        for (int i = 0; i < strLen; ++i) {
            ByteUtils.LITTLE_ENDIAN_CHAR.set(bytesToHash, 2 * i, routing.charAt(i));
        }
        return Murmur3HashFunction.hash(bytesToHash, 0, strLen * 2);
    }

    private static boolean assertHashWithoutInformationLoss(String routing) {
        for (int i = 0; i < routing.length(); ++i) {
            char c = routing.charAt(i);
            byte b1 = (byte)c;
            byte b2 = (byte)(c >>> 8);
            assert ((b1 & 0xFF | (b2 & 0xFF) << 8) == c);
        }
        return true;
    }

    public static int hash(byte[] bytes, int offset, int length) {
        return StringHelper.murmurhash3_x86_32((byte[])bytes, (int)offset, (int)length, (int)0);
    }
}

