/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.search.ArraySearchPhaseResults;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchProgressListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchShard;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.DelayableWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rank.context.QueryPhaseRankCoordinatorContext;

public class QueryPhaseResultConsumer
extends ArraySearchPhaseResults<SearchPhaseResult> {
    private static final Logger logger = LogManager.getLogger(QueryPhaseResultConsumer.class);
    private final Executor executor;
    private final CircuitBreaker circuitBreaker;
    private final SearchProgressListener progressListener;
    private final AggregationReduceContext.Builder aggReduceContextBuilder;
    private final QueryPhaseRankCoordinatorContext queryPhaseRankCoordinatorContext;
    private final int topNSize;
    private final boolean hasTopDocs;
    private final boolean hasAggs;
    private final boolean performFinalReduce;
    private final Consumer<Exception> onPartialMergeFailure;
    private final int batchReduceSize;
    private List<QuerySearchResult> buffer = new ArrayList<QuerySearchResult>();
    private List<SearchShard> emptyResults = new ArrayList<SearchShard>();
    private volatile long circuitBreakerBytes;
    private volatile long aggsCurrentBufferSize;
    private volatile long maxAggsCurrentBufferSize = 0L;
    private final ArrayDeque<MergeTask> queue = new ArrayDeque();
    private final AtomicReference<MergeTask> runningTask = new AtomicReference();
    final AtomicReference<Exception> failure = new AtomicReference();
    final SearchPhaseController.TopDocsStats topDocsStats;
    private volatile MergeResult mergeResult;
    private volatile boolean hasPartialReduce;
    private volatile int numReducePhases;
    private final ArrayDeque<Tuple<SearchPhaseController.TopDocsStats, MergeResult>> batchedResults = new ArrayDeque();
    private static final Comparator<QuerySearchResult> RESULT_COMPARATOR = Comparator.comparingInt(SearchPhaseResult::getShardIndex);

    public QueryPhaseResultConsumer(SearchRequest request, Executor executor, CircuitBreaker circuitBreaker, SearchPhaseController controller, Supplier<Boolean> isCanceled, SearchProgressListener progressListener, int expectedResultSize, Consumer<Exception> onPartialMergeFailure) {
        super(expectedResultSize);
        this.executor = executor;
        this.circuitBreaker = circuitBreaker;
        this.progressListener = progressListener;
        this.topNSize = SearchPhaseController.getTopDocsSize(request);
        this.performFinalReduce = request.isFinalReduce();
        this.onPartialMergeFailure = onPartialMergeFailure;
        SearchSourceBuilder source = request.source();
        int size = source == null || source.size() == -1 ? 10 : source.size();
        int from = source == null || source.from() == -1 ? 0 : source.from();
        this.queryPhaseRankCoordinatorContext = source == null || source.rankBuilder() == null ? null : source.rankBuilder().buildQueryPhaseCoordinatorContext(size, from);
        this.hasTopDocs = (source == null || size != 0) && this.queryPhaseRankCoordinatorContext == null;
        this.hasAggs = source != null && source.aggregations() != null;
        this.aggReduceContextBuilder = this.hasAggs ? controller.getReduceContext(isCanceled, source.aggregations()) : null;
        this.batchReduceSize = this.hasAggs || this.hasTopDocs ? Math.min(request.getBatchedReduceSize(), expectedResultSize) : expectedResultSize;
        this.topDocsStats = new SearchPhaseController.TopDocsStats(request.resolveTrackTotalHitsUpTo());
    }

    @Override
    protected synchronized void doClose() {
        assert (this.assertFailureAndBreakerConsistent());
        this.releaseBuffer();
        this.circuitBreaker.addWithoutBreaking(-this.circuitBreakerBytes);
        this.circuitBreakerBytes = 0L;
        if (this.hasPendingMerges()) {
            throw new IllegalStateException("Attempted to close with partial reduce in-flight");
        }
    }

    private boolean assertFailureAndBreakerConsistent() {
        boolean hasFailure;
        boolean bl = hasFailure = this.failure.get() != null;
        if (hasFailure ? !$assertionsDisabled && this.circuitBreakerBytes != 0L : !$assertionsDisabled && this.circuitBreakerBytes < 0L) {
            throw new AssertionError();
        }
        return true;
    }

    @Override
    public void consumeResult(SearchPhaseResult result, Runnable next) {
        super.consumeResult(result, () -> {});
        QuerySearchResult querySearchResult = result.queryResult();
        this.progressListener.notifyQueryResult(querySearchResult.getShardIndex(), querySearchResult);
        this.consume(querySearchResult, next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MergeResult consumePartialMergeResultDataNode() {
        List<QuerySearchResult> buffer;
        MergeResult mergeResult = this.mergeResult;
        this.mergeResult = null;
        assert (this.runningTask.get() == null);
        QueryPhaseResultConsumer queryPhaseResultConsumer = this;
        synchronized (queryPhaseResultConsumer) {
            buffer = this.buffer;
        }
        if (buffer != null && !buffer.isEmpty()) {
            this.buffer = null;
            buffer.sort(RESULT_COMPARATOR);
            mergeResult = this.partialReduce(buffer, this.emptyResults, this.topDocsStats, mergeResult, 0);
            this.emptyResults = null;
        }
        return mergeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBatchedPartialResult(SearchPhaseController.TopDocsStats topDocsStats, MergeResult mergeResult) {
        ArrayDeque<Tuple<SearchPhaseController.TopDocsStats, MergeResult>> arrayDeque = this.batchedResults;
        synchronized (arrayDeque) {
            this.batchedResults.add((Tuple<SearchPhaseController.TopDocsStats, MergeResult>)new Tuple((Object)topDocsStats, (Object)mergeResult));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchPhaseController.ReducedQueryPhase reduce() throws Exception {
        SearchPhaseController.ReducedQueryPhase reducePhase;
        InternalAggregations aggs;
        ArrayDeque<Tuple<SearchPhaseController.TopDocsStats, MergeResult>> batchedResults;
        List<QuerySearchResult> buffer;
        if (this.hasPendingMerges()) {
            throw new AssertionError((Object)"partial reduce in-flight");
        }
        Exception f = this.failure.get();
        if (f != null) {
            throw f;
        }
        QueryPhaseResultConsumer queryPhaseResultConsumer = this;
        synchronized (queryPhaseResultConsumer) {
            buffer = this.buffer;
            buffer = buffer == null ? Collections.emptyList() : buffer;
            this.buffer = null;
        }
        buffer.sort(RESULT_COMPARATOR);
        SearchPhaseController.TopDocsStats topDocsStats = this.topDocsStats;
        MergeResult mergeResult = this.mergeResult;
        ArrayDeque<Tuple<SearchPhaseController.TopDocsStats, MergeResult>> arrayDeque = this.batchedResults;
        synchronized (arrayDeque) {
            batchedResults = this.batchedResults;
        }
        int resultSize = buffer.size() + (mergeResult == null ? 0 : 1) + batchedResults.size();
        ArrayList<TopDocs> topDocsList = this.hasTopDocs ? new ArrayList<TopDocs>(resultSize) : null;
        final ArrayDeque<DelayableWriteable<InternalAggregations>> aggsList = this.hasAggs ? new ArrayDeque<DelayableWriteable<InternalAggregations>>(resultSize) : null;
        long breakerSize = this.circuitBreakerBytes;
        try {
            Tuple<SearchPhaseController.TopDocsStats, MergeResult> batchedResult;
            if (mergeResult != null) {
                QueryPhaseResultConsumer.consumePartialMergeResult(mergeResult, topDocsList, aggsList);
                breakerSize = this.addEstimateAndMaybeBreak(mergeResult.estimatedSize);
            }
            while ((batchedResult = batchedResults.poll()) != null) {
                topDocsStats.add((SearchPhaseController.TopDocsStats)batchedResult.v1());
                QueryPhaseResultConsumer.consumePartialMergeResult((MergeResult)batchedResult.v2(), topDocsList, aggsList);
                breakerSize = this.addEstimateAndMaybeBreak(((MergeResult)batchedResult.v2()).estimatedSize);
            }
            for (QuerySearchResult result : buffer) {
                topDocsStats.add(result.topDocs(), result.searchTimedOut(), result.terminatedEarly());
                if (topDocsList == null) continue;
                TopDocsAndMaxScore topDocs = result.consumeTopDocs();
                SearchPhaseController.setShardIndex(topDocs.topDocs, result.getShardIndex());
                topDocsList.add(topDocs.topDocs);
            }
            if (aggsList != null) {
                breakerSize = this.addEstimateAndMaybeBreak(QueryPhaseResultConsumer.estimateRamBytesUsedForReduce(this.circuitBreakerBytes));
                aggs = QueryPhaseResultConsumer.aggregate(buffer.iterator(), new Iterator<DelayableWriteable<InternalAggregations>>(this){

                    @Override
                    public boolean hasNext() {
                        return !aggsList.isEmpty();
                    }

                    @Override
                    public DelayableWriteable<InternalAggregations> next() {
                        return (DelayableWriteable)aggsList.pollFirst();
                    }
                }, resultSize, this.performFinalReduce ? this.aggReduceContextBuilder.forFinalReduction() : this.aggReduceContextBuilder.forPartialReduction());
            } else {
                aggs = null;
            }
            reducePhase = SearchPhaseController.reducedQueryPhase(this.results.asList(), aggs, topDocsList == null ? Collections.emptyList() : topDocsList, topDocsStats, this.numReducePhases, false, this.queryPhaseRankCoordinatorContext);
            buffer = null;
        }
        finally {
            if (buffer != null) {
                QueryPhaseResultConsumer.releaseAggs(buffer);
                if (aggsList != null) {
                    Releasables.close(aggsList);
                }
            }
        }
        if (this.hasAggs && aggs != null) {
            long finalSize = DelayableWriteable.getSerializedSize(reducePhase.aggregations()) - breakerSize;
            this.addWithoutBreaking(finalSize);
            logger.trace("aggs final reduction [{}] max [{}]", (Object)this.aggsCurrentBufferSize, (Object)this.maxAggsCurrentBufferSize);
        }
        if (this.progressListener != SearchProgressListener.NOOP) {
            this.progressListener.notifyFinalReduce(SearchProgressListener.buildSearchShards(this.results.asList()), reducePhase.totalHits(), reducePhase.aggregations(), reducePhase.numReducePhases());
        }
        return reducePhase;
    }

    private static void consumePartialMergeResult(MergeResult partialResult, List<TopDocs> topDocsList, Collection<DelayableWriteable<InternalAggregations>> aggsList) {
        if (topDocsList != null) {
            QueryPhaseResultConsumer.addTopDocsToList(partialResult, topDocsList);
        }
        if (aggsList != null) {
            QueryPhaseResultConsumer.addAggsToList(partialResult, aggsList);
        }
    }

    private static void addTopDocsToList(MergeResult partialResult, List<TopDocs> topDocsList) {
        if (partialResult.reducedTopDocs != null) {
            topDocsList.add(partialResult.reducedTopDocs);
        }
    }

    private static void addAggsToList(MergeResult partialResult, Collection<DelayableWriteable<InternalAggregations>> aggsList) {
        DelayableWriteable<InternalAggregations> aggs = partialResult.reducedAggs;
        if (aggs != null) {
            aggsList.add(aggs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MergeResult partialReduce(List<QuerySearchResult> toConsume, List<SearchShard> processedShards, SearchPhaseController.TopDocsStats topDocsStats, @Nullable MergeResult lastMerge, int numReducePhases) {
        InternalAggregations newAggs;
        TopDocs newTopDocs;
        ArrayList<TopDocs> topDocsList;
        toConsume.sort(RESULT_COMPARATOR);
        int resultSetSize = toConsume.size() + (lastMerge != null ? 1 : 0);
        if (this.hasTopDocs) {
            topDocsList = new ArrayList<TopDocs>(resultSetSize);
            if (lastMerge != null) {
                QueryPhaseResultConsumer.addTopDocsToList(lastMerge, topDocsList);
            }
        } else {
            topDocsList = null;
        }
        try {
            for (QuerySearchResult result : toConsume) {
                topDocsStats.add(result.topDocs(), result.searchTimedOut(), result.terminatedEarly());
                SearchShardTarget target = result.getSearchShardTarget();
                processedShards.add(new SearchShard(target.getClusterAlias(), target.getShardId()));
                if (topDocsList == null) continue;
                TopDocsAndMaxScore topDocs = result.consumeTopDocs();
                SearchPhaseController.setShardIndex(topDocs.topDocs, result.getShardIndex());
                topDocsList.add(topDocs.topDocs);
            }
            TopDocs topDocs = newTopDocs = topDocsList == null ? null : SearchPhaseController.mergeTopDocs(topDocsList, this.topNSize, 0);
            newAggs = this.hasAggs ? QueryPhaseResultConsumer.aggregate(toConsume.iterator(), lastMerge == null ? Collections.emptyIterator() : Iterators.single(lastMerge.reducedAggs), resultSetSize, this.aggReduceContextBuilder.forPartialReduction()) : null;
            for (QuerySearchResult querySearchResult : toConsume) {
                querySearchResult.markAsPartiallyReduced();
            }
            toConsume = null;
        }
        finally {
            QueryPhaseResultConsumer.releaseAggs(toConsume);
        }
        if (lastMerge != null) {
            processedShards.addAll(lastMerge.processedShards);
        }
        if (this.progressListener != SearchProgressListener.NOOP) {
            this.progressListener.notifyPartialReduce(processedShards, topDocsStats.getTotalHits(), newAggs, numReducePhases);
        }
        return new MergeResult(processedShards, newTopDocs, newAggs != null ? DelayableWriteable.referencing(newAggs) : null, newAggs != null ? DelayableWriteable.getSerializedSize(newAggs) : 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InternalAggregations aggregate(Iterator<QuerySearchResult> toConsume, Iterator<DelayableWriteable<InternalAggregations>> partialResults, int resultSetSize, AggregationReduceContext reduceContext) {
        try {
            Iterator<InternalAggregations> aggsIter = Iterators.map(toConsume, r -> {
                try (DelayableWriteable<InternalAggregations> res = r.consumeAggs();){
                    InternalAggregations internalAggregations = res.expand();
                    return internalAggregations;
                }
            });
            InternalAggregations internalAggregations = InternalAggregations.topLevelReduce(partialResults.hasNext() ? Iterators.concat(Iterators.map(partialResults, r -> {
                try (DelayableWriteable delayableWriteable = r;){
                    InternalAggregations internalAggregations = (InternalAggregations)r.expand();
                    return internalAggregations;
                }
            }), aggsIter) : aggsIter, resultSetSize, reduceContext);
            return internalAggregations;
        }
        finally {
            toConsume.forEachRemaining(QuerySearchResult::releaseAggs);
            partialResults.forEachRemaining(Releasable::close);
        }
    }

    public int getNumReducePhases() {
        return this.numReducePhases;
    }

    private boolean hasFailure() {
        return this.failure.get() != null;
    }

    private boolean hasPendingMerges() {
        return !this.queue.isEmpty() || this.runningTask.get() != null;
    }

    private synchronized void addWithoutBreaking(long size) {
        this.circuitBreaker.addWithoutBreaking(size);
        this.circuitBreakerBytes += size;
        this.maxAggsCurrentBufferSize = Math.max(this.maxAggsCurrentBufferSize, this.circuitBreakerBytes);
    }

    private synchronized long addEstimateAndMaybeBreak(long estimatedSize) {
        this.circuitBreaker.addEstimateBytesAndMaybeBreak(estimatedSize, "<reduce_aggs>");
        this.circuitBreakerBytes += estimatedSize;
        this.maxAggsCurrentBufferSize = Math.max(this.maxAggsCurrentBufferSize, this.circuitBreakerBytes);
        return this.circuitBreakerBytes;
    }

    private long ramBytesUsedQueryResult(QuerySearchResult result) {
        return this.hasAggs ? result.aggregations().getSerializedSize() : 0L;
    }

    private static long estimateRamBytesUsedForReduce(long size) {
        return Math.round(0.5 * (double)size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consume(QuerySearchResult result, Runnable next) {
        if (this.hasFailure()) {
            result.consumeAll();
            next.run();
        } else if (result.isNull() || result.isPartiallyReduced()) {
            SearchShardTarget target = result.getSearchShardTarget();
            SearchShard searchShard = new SearchShard(target.getClusterAlias(), target.getShardId());
            QueryPhaseResultConsumer queryPhaseResultConsumer = this;
            synchronized (queryPhaseResultConsumer) {
                this.emptyResults.add(searchShard);
            }
            next.run();
        } else {
            long aggsSize = this.ramBytesUsedQueryResult(result);
            boolean executeNextImmediately = true;
            boolean hasFailure = false;
            QueryPhaseResultConsumer queryPhaseResultConsumer = this;
            synchronized (queryPhaseResultConsumer) {
                if (this.hasFailure()) {
                    hasFailure = true;
                } else {
                    if (this.hasAggs) {
                        try {
                            this.addEstimateAndMaybeBreak(aggsSize);
                        }
                        catch (Exception exc) {
                            this.releaseBuffer();
                            this.onMergeFailure(exc);
                            hasFailure = true;
                        }
                    }
                    if (!hasFailure) {
                        List<QuerySearchResult> b = this.buffer;
                        this.aggsCurrentBufferSize += aggsSize;
                        int size = b.size() + (this.hasPartialReduce ? 1 : 0);
                        if (size >= this.batchReduceSize) {
                            this.hasPartialReduce = true;
                            executeNextImmediately = false;
                            MergeTask task = new MergeTask(b, this.aggsCurrentBufferSize, this.emptyResults, next);
                            b = this.buffer = new ArrayList<QuerySearchResult>();
                            this.emptyResults = new ArrayList<SearchShard>();
                            this.aggsCurrentBufferSize = 0L;
                            this.queue.add(task);
                            this.tryExecuteNext();
                        }
                        b.add(result);
                    }
                }
            }
            if (hasFailure) {
                result.consumeAll();
            }
            if (executeNextImmediately) {
                next.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseBuffer() {
        List<QuerySearchResult> b = this.buffer;
        if (b != null) {
            this.buffer = null;
            for (QuerySearchResult querySearchResult : b) {
                querySearchResult.releaseAggs();
            }
        }
        ArrayDeque<Tuple<SearchPhaseController.TopDocsStats, MergeResult>> arrayDeque = this.batchedResults;
        synchronized (arrayDeque) {
            Tuple<SearchPhaseController.TopDocsStats, MergeResult> batchedResult;
            while ((batchedResult = this.batchedResults.poll()) != null) {
                Releasables.close(((MergeResult)batchedResult.v2()).reducedAggs());
            }
        }
    }

    private synchronized void onMergeFailure(Exception exc) {
        MergeTask mergeTask;
        if (!this.failure.compareAndSet(null, exc)) {
            assert (this.circuitBreakerBytes == 0L);
            return;
        }
        assert (this.circuitBreakerBytes >= 0L);
        if (this.circuitBreakerBytes > 0L) {
            this.circuitBreaker.addWithoutBreaking(-this.circuitBreakerBytes);
            this.circuitBreakerBytes = 0L;
        }
        this.onPartialMergeFailure.accept(exc);
        MergeTask task = this.runningTask.getAndSet(null);
        if (task != null) {
            task.cancel();
        }
        while ((mergeTask = this.queue.pollFirst()) != null) {
            mergeTask.cancel();
        }
        this.mergeResult = null;
    }

    private void tryExecuteNext() {
        assert (Thread.holdsLock(this));
        if (this.hasFailure() || this.runningTask.get() != null) {
            return;
        }
        final MergeTask task = this.queue.poll();
        this.runningTask.set(task);
        if (task == null) {
            return;
        }
        this.executor.execute(new AbstractRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doRun() {
                MergeTask mergeTask = task;
                List<QuerySearchResult> toConsume = mergeTask.consumeBuffer();
                while (mergeTask != null) {
                    MergeResult newMerge;
                    MergeResult thisMergeResult = QueryPhaseResultConsumer.this.mergeResult;
                    long estimatedTotalSize = (thisMergeResult != null ? thisMergeResult.estimatedSize : 0L) + mergeTask.aggsBufferSize;
                    try {
                        long estimatedMergeSize = QueryPhaseResultConsumer.estimateRamBytesUsedForReduce(estimatedTotalSize);
                        QueryPhaseResultConsumer.this.addEstimateAndMaybeBreak(estimatedMergeSize);
                        estimatedTotalSize += estimatedMergeSize;
                        ++QueryPhaseResultConsumer.this.numReducePhases;
                        newMerge = QueryPhaseResultConsumer.this.partialReduce(toConsume, mergeTask.emptyResults, QueryPhaseResultConsumer.this.topDocsStats, thisMergeResult, QueryPhaseResultConsumer.this.numReducePhases);
                    }
                    catch (Exception t) {
                        QueryPhaseResultConsumer.releaseAggs(toConsume);
                        QueryPhaseResultConsumer.this.onMergeFailure(t);
                        return;
                    }
                    QueryPhaseResultConsumer t = QueryPhaseResultConsumer.this;
                    synchronized (t) {
                        if (QueryPhaseResultConsumer.this.hasFailure()) {
                            return;
                        }
                        QueryPhaseResultConsumer.this.mergeResult = newMerge;
                        if (QueryPhaseResultConsumer.this.hasAggs) {
                            long newSize = QueryPhaseResultConsumer.this.mergeResult.estimatedSize - estimatedTotalSize;
                            QueryPhaseResultConsumer.this.addWithoutBreaking(newSize);
                            if (logger.isTraceEnabled()) {
                                logger.trace("aggs partial reduction [{}->{}] max [{}]", (Object)estimatedTotalSize, (Object)QueryPhaseResultConsumer.this.mergeResult.estimatedSize, (Object)QueryPhaseResultConsumer.this.maxAggsCurrentBufferSize);
                            }
                        }
                    }
                    Runnable r = mergeTask.consumeListener();
                    QueryPhaseResultConsumer queryPhaseResultConsumer = QueryPhaseResultConsumer.this;
                    synchronized (queryPhaseResultConsumer) {
                        do {
                            mergeTask = QueryPhaseResultConsumer.this.queue.poll();
                            QueryPhaseResultConsumer.this.runningTask.set(mergeTask);
                        } while (mergeTask != null && (toConsume = mergeTask.consumeBuffer()) == null);
                    }
                    if (r == null) continue;
                    r.run();
                }
            }

            @Override
            public void onFailure(Exception exc) {
                QueryPhaseResultConsumer.this.onMergeFailure(exc);
            }
        });
    }

    private static void releaseAggs(@Nullable List<QuerySearchResult> toConsume) {
        if (toConsume != null) {
            for (QuerySearchResult result : toConsume) {
                result.releaseAggs();
            }
        }
    }

    record MergeResult(List<SearchShard> processedShards, @Nullable TopDocs reducedTopDocs, @Nullable DelayableWriteable<InternalAggregations> reducedAggs, long estimatedSize) implements Writeable
    {
        private static final TransportVersion BATCHED_QUERY_EXECUTION_DELAYABLE_WRITEABLE = TransportVersion.fromName("batched_query_execution_delayable_writeable");

        static MergeResult readFrom(StreamInput in) throws IOException {
            return new MergeResult(List.of(), Lucene.readTopDocsIncludingShardIndex(in), in.readOptionalWriteable(i -> {
                if (i.getTransportVersion().supports(BATCHED_QUERY_EXECUTION_DELAYABLE_WRITEABLE)) {
                    return DelayableWriteable.delayed(InternalAggregations::readFrom, i);
                }
                return DelayableWriteable.referencing(InternalAggregations.readFrom(i));
            }), in.readVLong());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            Lucene.writeTopDocsIncludingShardIndex(out, this.reducedTopDocs);
            out.writeOptionalWriteable(this.reducedAggs == null ? null : (out.getTransportVersion().supports(BATCHED_QUERY_EXECUTION_DELAYABLE_WRITEABLE) ? this.reducedAggs : this.reducedAggs.expand()));
            out.writeVLong(this.estimatedSize);
        }
    }

    private static class MergeTask {
        private final List<SearchShard> emptyResults;
        private List<QuerySearchResult> buffer;
        private final long aggsBufferSize;
        private Runnable next;

        private MergeTask(List<QuerySearchResult> buffer, long aggsBufferSize, List<SearchShard> emptyResults, Runnable next) {
            this.buffer = buffer;
            this.aggsBufferSize = aggsBufferSize;
            this.emptyResults = emptyResults;
            this.next = next;
        }

        public synchronized List<QuerySearchResult> consumeBuffer() {
            List<QuerySearchResult> toRet = this.buffer;
            this.buffer = null;
            return toRet;
        }

        public synchronized Runnable consumeListener() {
            Runnable n = this.next;
            this.next = null;
            return n;
        }

        public void cancel() {
            Runnable next;
            List<QuerySearchResult> buffer = this.consumeBuffer();
            if (buffer != null) {
                QueryPhaseResultConsumer.releaseAggs(buffer);
            }
            if ((next = this.consumeListener()) != null) {
                next.run();
            }
        }
    }
}

