/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.PercentileFloatAggregatorFunction;
import org.elasticsearch.compute.aggregation.PercentileFloatGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class PercentileFloatAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final double percentile;

    public PercentileFloatAggregatorFunctionSupplier(double percentile) {
        this.percentile = percentile;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return PercentileFloatAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return PercentileFloatGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public PercentileFloatAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return PercentileFloatAggregatorFunction.create(driverContext, channels, this.percentile);
    }

    @Override
    public PercentileFloatGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return PercentileFloatGroupingAggregatorFunction.create(channels, driverContext, this.percentile);
    }

    @Override
    public String describe() {
        return "percentile of floats";
    }
}

