/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.ingest;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ingest.PutPipelineRequest;
import org.elasticsearch.action.ingest.PutPipelineTransportAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentType;

@ServerlessScope(value=Scope.PUBLIC)
public class RestPutPipelineAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_ingest/pipeline/{id}"));
    }

    @Override
    public String getName() {
        return "ingest_put_pipeline_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        Integer ifVersion = null;
        if (restRequest.hasParam("if_version")) {
            String versionString = restRequest.param("if_version");
            try {
                ifVersion = Integer.parseInt(versionString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "invalid value [%s] specified for [if_version]. must be an integer value", versionString));
            }
        }
        Tuple<XContentType, ReleasableBytesReference> sourceTuple = restRequest.contentOrSourceParam();
        ReleasableBytesReference content = sourceTuple.v2();
        PutPipelineRequest request = new PutPipelineRequest(RestUtils.getMasterNodeTimeout(restRequest), RestUtils.getAckTimeout(restRequest), restRequest.param("id"), content, sourceTuple.v1(), ifVersion);
        return channel -> client.execute(PutPipelineTransportAction.TYPE, request, ActionListener.withRef(new RestToXContentListener((RestChannel)channel), content));
    }
}

