/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;

public class IndexingStatsSettings {
    static final TimeValue RECENT_WRITE_LOAD_HALF_LIFE_DEFAULT = TimeValue.timeValueMinutes(5L);
    static final TimeValue RECENT_WRITE_LOAD_HALF_LIFE_MIN = TimeValue.timeValueSeconds(1L);
    static final TimeValue RECENT_WRITE_LOAD_HALF_LIFE_MAX = TimeValue.timeValueDays(100000L);
    public static final Setting<TimeValue> RECENT_WRITE_LOAD_HALF_LIFE_SETTING = Setting.timeSetting("indices.stats.recent_write_load.half_life", RECENT_WRITE_LOAD_HALF_LIFE_DEFAULT, RECENT_WRITE_LOAD_HALF_LIFE_MIN, RECENT_WRITE_LOAD_HALF_LIFE_MAX, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private final AtomicReference<TimeValue> recentWriteLoadHalfLifeForNewShards = new AtomicReference<TimeValue>(RECENT_WRITE_LOAD_HALF_LIFE_SETTING.getDefault(Settings.EMPTY));

    public IndexingStatsSettings(ClusterSettings clusterSettings) {
        clusterSettings.initializeAndWatch(RECENT_WRITE_LOAD_HALF_LIFE_SETTING, this.recentWriteLoadHalfLifeForNewShards::set);
    }

    TimeValue getRecentWriteLoadHalfLifeForNewShards() {
        return this.recentWriteLoadHalfLifeForNewShards.get();
    }
}

