/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.util.BitUtil;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;

public class FieldArrayContext {
    private static final String OFFSETS_FIELD_NAME_SUFFIX = ".offsets";
    private final Map<String, Offsets> offsetsPerField = new HashMap<String, Offsets>();

    public void recordOffset(String field, Comparable<?> value) {
        Offsets arrayOffsets = this.offsetsPerField.computeIfAbsent(field, k -> new Offsets());
        int nextOffset = arrayOffsets.currentOffset++;
        List offsets = arrayOffsets.valueToOffsets.computeIfAbsent(value, s -> new ArrayList(2));
        offsets.add(nextOffset);
    }

    public void recordNull(String field) {
        Offsets arrayOffsets = this.offsetsPerField.computeIfAbsent(field, k -> new Offsets());
        int nextOffset = arrayOffsets.currentOffset++;
        arrayOffsets.nullValueOffsets.add(nextOffset);
    }

    void maybeRecordEmptyArray(String field) {
        this.offsetsPerField.computeIfAbsent(field, k -> new Offsets());
    }

    void addToLuceneDocument(DocumentParserContext context) throws IOException {
        for (Map.Entry<String, Offsets> entry : this.offsetsPerField.entrySet()) {
            String fieldName = entry.getKey();
            Offsets offset = entry.getValue();
            int currentOrd = 0;
            int[] offsetToOrd = new int[offset.currentOffset];
            for (Map.Entry<Comparable<?>, List<Integer>> offsetEntry : offset.valueToOffsets.entrySet()) {
                for (Integer offsetAndLevel : offsetEntry.getValue()) {
                    offsetToOrd[offsetAndLevel.intValue()] = currentOrd;
                }
                ++currentOrd;
            }
            for (Integer nullOffset : offset.nullValueOffsets) {
                offsetToOrd[nullOffset.intValue()] = -1;
            }
            int expectedSize = offsetToOrd.length + 1;
            try (BytesStreamOutput streamOutput = new BytesStreamOutput(expectedSize);){
                streamOutput.writeVInt(BitUtil.zigZagEncode(offsetToOrd.length));
                for (Object ord : (Object)offsetToOrd) {
                    streamOutput.writeVInt(BitUtil.zigZagEncode((int)ord));
                }
                context.doc().add(new SortedDocValuesField(fieldName, streamOutput.bytes().toBytesRef()));
            }
        }
    }

    static int[] parseOffsetArray(StreamInput in) throws IOException {
        int[] offsetToOrd = new int[BitUtil.zigZagDecode(in.readVInt())];
        for (int i = 0; i < offsetToOrd.length; ++i) {
            offsetToOrd[i] = BitUtil.zigZagDecode(in.readVInt());
        }
        return offsetToOrd;
    }

    public static String getOffsetsFieldName(MapperBuilderContext context, Mapper.SourceKeepMode indexSourceKeepMode, boolean hasDocValues, boolean isStored, FieldMapper.Builder fieldMapperBuilder, IndexVersion indexCreatedVersion, IndexVersion minSupportedVersionMain) {
        Mapper.SourceKeepMode sourceKeepMode = fieldMapperBuilder.sourceKeepMode.orElse(indexSourceKeepMode);
        if (context.isSourceSynthetic() && sourceKeepMode == Mapper.SourceKeepMode.ARRAYS && hasDocValues && !isStored && !context.isInNestedContext() && fieldMapperBuilder.copyTo.copyToFields().isEmpty() && !fieldMapperBuilder.multiFieldsBuilder.hasMultiFields() && FieldArrayContext.indexVersionSupportStoringArraysNatively(indexCreatedVersion, minSupportedVersionMain)) {
            return context.buildFullName(fieldMapperBuilder.leafName() + OFFSETS_FIELD_NAME_SUFFIX);
        }
        return null;
    }

    private static boolean indexVersionSupportStoringArraysNatively(IndexVersion indexCreatedVersion, IndexVersion minSupportedVersionMain) {
        return indexCreatedVersion.onOrAfter(minSupportedVersionMain) || indexCreatedVersion.between(IndexVersions.SYNTHETIC_SOURCE_STORE_ARRAYS_NATIVELY_BACKPORT_8_X, IndexVersions.UPGRADE_TO_LUCENE_10_0_0);
    }

    private static class Offsets {
        int currentOffset;
        final Map<Comparable<?>, List<Integer>> valueToOffsets = new TreeMap();
        final List<Integer> nullValueOffsets = new ArrayList<Integer>(2);

        private Offsets() {
        }
    }
}

