/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.AdaptiveAllocations;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ElasticsearchServiceSettings
implements JsonpSerializable {
    @Nullable
    private final AdaptiveAllocations adaptiveAllocations;
    @Nullable
    private final String deploymentId;
    private final String modelId;
    @Nullable
    private final Integer numAllocations;
    private final int numThreads;
    public static final JsonpDeserializer<ElasticsearchServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ElasticsearchServiceSettings::setupElasticsearchServiceSettingsDeserializer);

    private ElasticsearchServiceSettings(Builder builder) {
        this.adaptiveAllocations = builder.adaptiveAllocations;
        this.deploymentId = builder.deploymentId;
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.numAllocations = builder.numAllocations;
        this.numThreads = ApiTypeHelper.requireNonNull(builder.numThreads, (Object)this, "numThreads", 0);
    }

    public static ElasticsearchServiceSettings of(Function<Builder, ObjectBuilder<ElasticsearchServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final AdaptiveAllocations adaptiveAllocations() {
        return this.adaptiveAllocations;
    }

    @Nullable
    public final String deploymentId() {
        return this.deploymentId;
    }

    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final Integer numAllocations() {
        return this.numAllocations;
    }

    public final int numThreads() {
        return this.numThreads;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.adaptiveAllocations != null) {
            generator.writeKey("adaptive_allocations");
            this.adaptiveAllocations.serialize(generator, mapper);
        }
        if (this.deploymentId != null) {
            generator.writeKey("deployment_id");
            generator.write(this.deploymentId);
        }
        generator.writeKey("model_id");
        generator.write(this.modelId);
        if (this.numAllocations != null) {
            generator.writeKey("num_allocations");
            generator.write(this.numAllocations);
        }
        generator.writeKey("num_threads");
        generator.write(this.numThreads);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupElasticsearchServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::adaptiveAllocations, AdaptiveAllocations._DESERIALIZER, "adaptive_allocations");
        op.add(Builder::deploymentId, JsonpDeserializer.stringDeserializer(), "deployment_id");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::numAllocations, JsonpDeserializer.integerDeserializer(), "num_allocations");
        op.add(Builder::numThreads, JsonpDeserializer.integerDeserializer(), "num_threads");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ElasticsearchServiceSettings> {
        @Nullable
        private AdaptiveAllocations adaptiveAllocations;
        @Nullable
        private String deploymentId;
        private String modelId;
        @Nullable
        private Integer numAllocations;
        private Integer numThreads;

        public final Builder adaptiveAllocations(@Nullable AdaptiveAllocations value) {
            this.adaptiveAllocations = value;
            return this;
        }

        public final Builder adaptiveAllocations(Function<AdaptiveAllocations.Builder, ObjectBuilder<AdaptiveAllocations>> fn) {
            return this.adaptiveAllocations(fn.apply(new AdaptiveAllocations.Builder()).build());
        }

        public final Builder deploymentId(@Nullable String value) {
            this.deploymentId = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder numAllocations(@Nullable Integer value) {
            this.numAllocations = value;
            return this;
        }

        public final Builder numThreads(int value) {
            this.numThreads = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ElasticsearchServiceSettings build() {
            this._checkSingleUse();
            return new ElasticsearchServiceSettings(this);
        }
    }
}

