"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createWorkflowService = exports.WorkflowServiceImpl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _saved_objects = require("../../saved_objects");
var _scoped_service = require("./scoped_service");
var _client = require("./client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createWorkflowService = args => {
  return new WorkflowServiceImpl(args);
};
exports.createWorkflowService = createWorkflowService;
class WorkflowServiceImpl {
  constructor({
    registry,
    savedObjects,
    security,
    logger
  }) {
    (0, _defineProperty2.default)(this, "savedObjects", void 0);
    (0, _defineProperty2.default)(this, "security", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "registry", void 0);
    this.savedObjects = savedObjects;
    this.security = security;
    this.logger = logger;
    this.registry = registry;
  }
  async asScoped({
    request
  }) {
    const user = this.security.authc.getCurrentUser(request);
    if (!user) {
      throw new Error('No user bound to the provided request');
    }
    const soClient = this.savedObjects.getScopedClient(request, {
      includedHiddenTypes: [_saved_objects.workflowSoTypeName]
    });
    const client = new _client.WorkflowClientImpl({
      logger: this.logger.get('client'),
      client: soClient,
      user: {
        id: user.profile_uid,
        username: user.username
      }
    });
    return new _scoped_service.ScopedWorkflowServiceImpl({
      client,
      registry: this.registry
    });
  }
}
exports.WorkflowServiceImpl = WorkflowServiceImpl;