"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enterWorkflow = exports.enterNode = exports.createInitialExecutionState = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createInitialExecutionState = ({
  runId,
  workflowId
}) => {
  return {
    runId,
    workflowId,
    rootWorkflowId: workflowId,
    callChain: []
  };
};
exports.createInitialExecutionState = createInitialExecutionState;
const enterNode = ({
  parent: {
    runId,
    workflowId,
    rootWorkflowId,
    callChain
  },
  nodeId
}) => {
  return {
    runId,
    workflowId,
    rootWorkflowId,
    stepId: nodeId,
    callChain: [...callChain, {
      type: 'node',
      id: nodeId
    }]
  };
};
exports.enterNode = enterNode;
const enterWorkflow = ({
  parent: {
    runId,
    rootWorkflowId,
    callChain
  },
  workflowId
}) => {
  return {
    runId,
    workflowId,
    rootWorkflowId,
    callChain: [...callChain, {
      type: 'workflow',
      id: workflowId
    }]
  };
};
exports.enterWorkflow = enterWorkflow;