"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNodeRunner = void 0;
var _wcFrameworkTypesServer = require("@kbn/wc-framework-types-server");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns a step runner already scoped to the given context.
 */
const createNodeRunner = params => {
  return args => {
    return runNode({
      ...params,
      ...args
    });
  };
};
exports.createNodeRunner = createNodeRunner;
const runNode = async ({
  nodeDefinition,
  state,
  internalContext
}) => {
  // update the execution state - context is already a copy, it's safe to reference
  internalContext.executionState = (0, _utils.enterNode)({
    parent: internalContext.executionState,
    nodeId: nodeDefinition.id
  });
  const {
    nodeRegistry,
    eventHandler
  } = internalContext;
  if (!nodeRegistry.has(nodeDefinition.type)) {
    throw new _wcFrameworkTypesServer.WorkflowExecutionError(`Node type [${nodeDefinition.type}] not found in registry`, 'nodeTypeNotFound', {
      state: internalContext.executionState
    });
  }
  const nodeType = nodeRegistry.get(nodeDefinition.type);
  let nodeServices = createBaseNodeServices({
    internalContext
  });
  if (nodeType.customServicesProvider) {
    const customServices = await nodeType.customServicesProvider();
    nodeServices = {
      ...nodeServices,
      ...customServices
    };
  }
  // TODO: check / call nodeType.customServicesProvider if present

  const context = {
    nodeConfiguration: nodeDefinition,
    services: nodeServices
  };
  const nodeRunner = nodeType.factory(context);

  // creating the event reporter
  const eventReporter = (0, _utils.createNodeEventReporter)({
    onEvent: eventHandler,
    meta: {
      workflowId: internalContext.executionState.workflowId,
      nodeId: nodeDefinition.id,
      nodeType: nodeDefinition.type
    }
  });

  // executing the node
  await nodeRunner.run({
    input: nodeDefinition.configuration,
    state,
    eventReporter,
    executionState: {
      ...internalContext.executionState
    }
  });
};
const createBaseNodeServices = ({
  internalContext: {
    logger,
    modelProvider,
    toolProvider,
    esClusterClient,
    nodeRegistry,
    workflowRegistry,
    getRunner
  }
}) => {
  return {
    logger: logger.get('workflow-runner'),
    modelProvider,
    toolProvider,
    esClusterClient,
    nodeRegistry,
    workflowRegistry,
    workflowRunner: getRunner()
  };
};