"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runNodeSequence = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Utility function to run a sequence of nodes.
 */
const runNodeSequence = async ({
  runner,
  sequence,
  state
}) => {
  for (let i = 0; i < sequence.length; i++) {
    const node = sequence[i];
    await runner.runNode({
      nodeDefinition: node,
      state
    });
  }
};
exports.runNodeSequence = runNodeSequence;