"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getWorkflowExecutionNodeTypeDefinition = void 0;
var _wcFrameworkTypesCommon = require("@kbn/wc-framework-types-common");
var _wcFrameworkTypesServer = require("@kbn/wc-framework-types-server");
var _state = require("../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getWorkflowExecutionNodeTypeDefinition = () => {
  return {
    id: _wcFrameworkTypesCommon.NodeType.workflowExecution,
    name: 'Workflow execution',
    description: 'Execute a workflow with predefined or dynamic parameters',
    factory: context => {
      return {
        run: async ({
          input,
          state,
          executionState
        }) => {
          const {
            services: {
              workflowRegistry,
              workflowRunner
            }
          } = context;
          const interpolatedInput = (0, _state.interpolateValue)(input, state);
          const {
            workflowId,
            inputs,
            output
          } = interpolatedInput;
          if (!workflowRegistry.has(workflowId)) {
            throw new _wcFrameworkTypesServer.WorkflowExecutionError(`Workflow with id [${workflowId}] not found`, 'workflowNotFound', {
              state: executionState
            });
          }
          const workflowDefinition = workflowRegistry.get(workflowId);
          const workflowResult = await workflowRunner.runWorkflow({
            workflowDefinition,
            inputs
          });
          const workflowOutput = workflowResult.output;
          state.set(output, workflowOutput);
        }
      };
    }
  };
};
exports.getWorkflowExecutionNodeTypeDefinition = getWorkflowExecutionNodeTypeDefinition;