"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLoopNodeTypeDefinition = void 0;
var _wcFrameworkTypesCommon = require("@kbn/wc-framework-types-common");
var _wcFrameworkTypesServer = require("@kbn/wc-framework-types-server");
var _state = require("../../state");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLoopNodeTypeDefinition = () => {
  return {
    id: _wcFrameworkTypesCommon.NodeType.loop,
    name: 'Loop',
    description: 'Executes a sequence for each element in a list',
    factory: context => {
      return {
        run: async ({
          input,
          state,
          executionState
        }) => {
          const {
            services: {
              workflowRunner
            }
          } = context;

          // no interpolation for nested steps - we let the underlying nodes do it on their own
          const {
            steps,
            output
          } = input;
          let inputList = (0, _state.interpolateValue)(input.inputList, state);
          if (typeof inputList === 'string') {
            inputList = state.get(inputList);
          }
          if (!Array.isArray(inputList)) {
            throw new _wcFrameworkTypesServer.WorkflowExecutionError(`Interpolating inputList parameter (${input.inputList}) resulted on a non-array variable`, 'invalidConfiguration', {
              state: executionState
            });
          }
          const itemVar = (0, _state.interpolateValue)(input.itemVar, state);
          if (typeof itemVar !== 'string') {
            throw new _wcFrameworkTypesServer.WorkflowExecutionError('itemVar interpolated to a non-string value', 'invalidParameter', {
              state: executionState
            });
          }

          // TODO: need to figure out if we clone the state or not
          const loopState = state;
          const resultList = [];
          for (let i = 0; i < inputList.length; i++) {
            const currentItem = inputList[i];
            loopState.set(itemVar, currentItem);
            await (0, _utils.runNodeSequence)({
              sequence: steps,
              runner: workflowRunner,
              state: loopState
            });
            if (output) {
              const result = loopState.get(output.source);
              resultList.push(result);
            }
          }
          if (output) {
            state.set(output.destination, resultList);
          }
        }
      };
    }
  };
};
exports.getLoopNodeTypeDefinition = getLoopNodeTypeDefinition;