"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerBuiltInNodeTypes = void 0;
var _tool_execution = require("./tool_execution");
var _workflow_execution = require("./workflow_execution");
var _parallel_sequences = require("./parallel_sequences");
var _prompt = require("./prompt");
var _loop = require("./loop");
var _intent_recognition = require("./intent_recognition");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerBuiltInNodeTypes = ({
  registry
}) => {
  const definitions = [(0, _tool_execution.getToolExecutionNodeTypeDefinition)(), (0, _workflow_execution.getWorkflowExecutionNodeTypeDefinition)(), (0, _parallel_sequences.getParallelSequencesNodeTypeDefinition)(), (0, _prompt.getPromptNodeTypeDefinition)(), (0, _loop.getLoopNodeTypeDefinition)(), (0, _intent_recognition.getIntentRecognitionNodeTypeDefinition)()];
  definitions.forEach(definition => {
    registry.register(definition);
  });
};
exports.registerBuiltInNodeTypes = registerBuiltInNodeTypes;