"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSetupServices = void 0;
exports.createStartServices = createStartServices;
var _workflow = require("./workflow");
var _runner = require("./runner");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createSetupServices = () => {
  const workflowRegistry = (0, _workflow.createWorkflowRegistry)();
  const nodeRegistry = (0, _runner.createNodeTypeRegistry)();
  const toolRegistry = (0, _runner.createToolRegistry)();
  return {
    workflowRegistry,
    nodeRegistry,
    toolRegistry
  };
};
exports.createSetupServices = createSetupServices;
function createStartServices({
  core,
  config,
  logger,
  pluginsDependencies,
  setupServices
}) {
  const {
    inference,
    actions
  } = pluginsDependencies;
  const modelProviderFactory = (0, _runner.createModelProviderFactory)({
    inference,
    actions
  });
  const workflowRunner = (0, _runner.createWorkflowRunner)({
    logger: logger.get('workflow-runner'),
    core,
    workflowRegistry: setupServices.workflowRegistry,
    nodeRegistry: setupServices.nodeRegistry,
    toolRegistry: setupServices.toolRegistry,
    modelProviderFactory
  });
  const workflowService = (0, _workflow.createWorkflowService)({
    registry: setupServices.workflowRegistry,
    logger: logger.get('workflow-service'),
    savedObjects: core.savedObjects,
    security: core.security
  });
  return {
    workflowRunner,
    workflowService
  };
}