"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkChatAppPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _services = require("./services");
var _application = require("./application");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class WorkChatAppPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "services", void 0);
  }
  setup(core, pluginDeps) {
    (0, _application.registerApp)({
      core,
      getServices: () => {
        if (!this.services) {
          throw new Error('getServices called before plugin start');
        }
        return this.services;
      }
    });
    return {};
  }
  start(core, pluginDeps) {
    this.services = (0, _services.createServices)({
      core
    });
    return {};
  }
  stop() {}
}
exports.WorkChatAppPlugin = WorkChatAppPlugin;