"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.userMessageToLangchain = exports.toolResultToLangchain = exports.conversationEventsToMessages = exports.assistantMessageToLangchain = void 0;
var _messages = require("@langchain/core/messages");
var _conversation_events = require("../../../../common/conversation_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const conversationEventsToMessages = events => {
  return events.map(event => {
    if ((0, _conversation_events.isUserMessage)(event)) {
      return [userMessageToLangchain(event)];
    }
    if ((0, _conversation_events.isAssistantMessage)(event)) {
      return [assistantMessageToLangchain(event)];
    }
    if ((0, _conversation_events.isToolResult)(event)) {
      return [toolResultToLangchain(event)];
    } else {
      // not handling other types for now.
      return [];
    }
  }).flat();
};
exports.conversationEventsToMessages = conversationEventsToMessages;
const userMessageToLangchain = message => {
  return new _messages.HumanMessage({
    content: message.content
  });
};
exports.userMessageToLangchain = userMessageToLangchain;
const assistantMessageToLangchain = message => {
  return new _messages.AIMessage({
    content: message.content,
    tool_calls: message.toolCalls.map(toolCall => {
      return {
        id: toolCall.toolCallId,
        name: toolCall.toolName,
        args: toolCall.args,
        type: 'tool_call'
      };
    })
  });
};
exports.assistantMessageToLangchain = assistantMessageToLangchain;
const toolResultToLangchain = message => {
  return new _messages.ToolMessage({
    tool_call_id: message.toolCallId,
    content: message.toolResult
  });
};
exports.toolResultToLangchain = toolResultToLangchain;